/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.advancement.criterion;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;
import org.cyclops.integrateddynamics.core.network.event.NetworkInitializedEvent;

public class NetworkInitializedTrigger
extends SimpleCriterionTrigger<Instance> {
    private final ResourceLocation ID = new ResourceLocation("integrateddynamics", "network_initialized");

    public NetworkInitializedTrigger() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ResourceLocation m_7295_() {
        return this.ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate entityPredicate, DeserializationContext conditionsParser) {
        return new Instance(this.m_7295_(), entityPredicate, json.get("min_cables").getAsInt());
    }

    public void test(ServerPlayer player, NetworkInitializedEvent event) {
        this.m_66234_(player, instance -> instance.test(player, event));
    }

    @SubscribeEvent
    public void onCrafted(NetworkInitializedEvent event) {
        if (event.getPlacer() != null && event.getPlacer() instanceof ServerPlayer) {
            this.test((ServerPlayer)event.getPlacer(), event);
        }
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance
    implements ICriterionInstanceTestable<NetworkInitializedEvent> {
        private final int minCablesCount;

        public Instance(ResourceLocation criterionIn, ContextAwarePredicate player, int minCablesCount) {
            super(criterionIn, player);
            this.minCablesCount = minCablesCount;
        }

        public boolean test(ServerPlayer player, NetworkInitializedEvent networkEvent) {
            return networkEvent.getNetwork().getCablesCount() >= this.minCablesCount;
        }
    }
}

