/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodiumCompat {
    private static final Logger LOG;
    @Nullable
    private static final MethodHandle METHOD_HANDLE;

    public static void markSpriteActive(TextureAtlasSprite sprite) {
        if (sprite != null && METHOD_HANDLE != null) {
            try {
                METHOD_HANDLE.invokeExact(sprite);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to invoke SpriteUtil#markSpriteActive", e);
            }
        }
    }

    static {
        MethodHandle handle;
        block2: {
            LOG = LoggerFactory.getLogger(SodiumCompat.class);
            handle = null;
            try {
                handle = MethodHandles.lookup().findStatic(Class.forName("me.jellysquid.mods.sodium.client.render.texture.SpriteUtil"), "markSpriteActive", MethodType.methodType(Void.TYPE, TextureAtlasSprite.class));
                LOG.info("Loaded Sodium active sprite compat.");
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                if (!ModList.get().getModContainerById("sodium").isPresent()) break block2;
                LOG.error("Failed to load Sodium active sprite compat.", (Throwable)e);
            }
        }
        METHOD_HANDLE = handle;
    }
}

