/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import guideme.color.LightDarkMode;
import guideme.internal.GuideME;
import guideme.render.GuiSprite;
import guideme.render.GuiSpriteScaling;
import guideme.render.SpritePadding;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuiAssets {
    private static final Logger LOG = LoggerFactory.getLogger(GuiAssets.class);
    private static final Map<ResourceLocation, GuiSprite> sprites = new ConcurrentHashMap<ResourceLocation, GuiSprite>();
    public static final ResourceLocation GUI_SPRITE_ATLAS = GuideME.makeId("textures/atlas/gui.png");
    public static final GuiSprite GUIDE_BACKGROUND = GuiAssets.sprite("background");
    public static final GuiSprite WINDOW_SPRITE = GuiAssets.sprite("window");
    public static final GuiSprite INNER_BORDER_SPRITE = GuiAssets.sprite("window_inner");
    public static final GuiSprite SLOT_BACKGROUND = GuiAssets.sprite("slot");
    public static final GuiSprite SLOT_LARGE_BACKGROUND = GuiAssets.sprite("slot_large");
    public static final GuiSprite SLOT_BORDER = GuiAssets.sprite("slot_border");
    public static final GuiSprite SLOT = GuiAssets.sprite("slot");
    public static final GuiSprite LARGE_SLOT = GuiAssets.sprite("large_slot");
    public static final GuiSprite ARROW = GuiAssets.sprite("recipe_arrow");

    private GuiAssets() {
    }

    public static GuiSprite sprite(String id) {
        return GuiAssets.sprite(GuideME.makeId(id));
    }

    public static GuiSprite sprite(ResourceLocation id) {
        return sprites.computeIfAbsent(id, GuiSprite::new);
    }

    public static void resetSprites() {
        LOG.debug("Resetting {} GUI sprites.", (Object)sprites.size());
        for (GuiSprite sprite : sprites.values()) {
            sprite.reset();
        }
    }

    public static SpritePadding getWindowPadding() {
        return GuiAssets.getNineSliceSprite((GuiSprite)GuiAssets.WINDOW_SPRITE, (LightDarkMode)LightDarkMode.LIGHT_MODE).padding;
    }

    public static NineSliceSprite getNineSliceSprite(GuiSprite guiSprite, LightDarkMode mode) {
        GuiSpriteScaling guiSpriteScaling = guiSprite.spriteScaling();
        if (!(guiSpriteScaling instanceof GuiSpriteScaling.NineSlice)) {
            throw new IllegalStateException("Expected sprite " + guiSprite + " to be a nine-slice sprite!");
        }
        GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)guiSpriteScaling;
        TextureAtlasSprite sprite = guiSprite.atlasSprite(mode);
        GuiSpriteScaling.NineSlice.Border border = nineSlice.border();
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118367_((double)((float)border.left() / (float)nineSlice.width() * 16.0f));
        float u2 = sprite.m_118367_((double)((1.0f - (float)border.right() / (float)nineSlice.width()) * 16.0f));
        float u3 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118393_((double)((float)border.top() / (float)nineSlice.height() * 16.0f));
        float v2 = sprite.m_118393_((double)((1.0f - (float)border.bottom() / (float)nineSlice.height()) * 16.0f));
        float v3 = sprite.m_118412_();
        return new NineSliceSprite(sprite.m_247685_(), new SpritePadding(border.left(), border.top(), border.right(), border.bottom()), new float[]{u0, u1, u2, u3, v0, v1, v2, v3});
    }

    public record NineSliceSprite(ResourceLocation atlasLocation, SpritePadding padding, float[] uv) {
    }
}

