/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import guideme.internal.MutableGuide;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(GuideRegistry.class);
    private static final ConcurrentHashMap<ResourceLocation, MutableGuide> guides = new ConcurrentHashMap();
    private static final Map<ResourceLocation, MutableGuide> dataDrivenGuides = new HashMap<ResourceLocation, MutableGuide>();
    private static volatile Map<ResourceLocation, MutableGuide> mergedGuides = Map.of();

    public static Collection<MutableGuide> getAll() {
        return mergedGuides.values();
    }

    public static Collection<MutableGuide> getStaticGuides() {
        return List.copyOf(guides.values());
    }

    @Nullable
    public static MutableGuide getById(ResourceLocation id) {
        return mergedGuides.get(id);
    }

    public static void registerStatic(MutableGuide guide) {
        if (guides.putIfAbsent(guide.getId(), guide) != null) {
            throw new IllegalStateException("There is already a Guide registered with id " + guide.getId());
        }
        GuideRegistry.rebuildGuides();
    }

    public static void unregisterStatic(MutableGuide guide) {
        if (guides.remove(guide.getId(), guide)) {
            GuideRegistry.rebuildGuides();
        }
    }

    public static void setDataDriven(Map<ResourceLocation, MutableGuide> guides) {
        dataDrivenGuides.clear();
        dataDrivenGuides.putAll(guides);
        GuideRegistry.rebuildGuides();
    }

    private static void rebuildGuides() {
        HashMap<ResourceLocation, MutableGuide> merged = new HashMap<ResourceLocation, MutableGuide>(guides);
        ArrayList<ResourceLocation> overridden = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, MutableGuide> entry : dataDrivenGuides.entrySet()) {
            if (merged.put(entry.getKey(), entry.getValue()) == null) continue;
            overridden.add(entry.getKey());
        }
        if (!overridden.isEmpty()) {
            Collections.sort(overridden);
            LOG.info("The following guides are overridden in resource packs: {}", overridden);
        }
        mergedGuides = Map.copyOf(merged);
    }
}

