/*
 * Decompiled with CFR 0.152.
 */
package guideme.compiler.tags;

import guideme.PageAnchor;
import guideme.compiler.PageCompiler;
import guideme.compiler.tags.FlowTagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.flow.LytFlowLink;
import guideme.document.flow.LytFlowParent;
import guideme.document.flow.LytTooltipSpan;
import guideme.document.interaction.ItemTooltip;
import guideme.indices.ItemIndex;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import java.util.Set;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ItemLinkCompiler
extends FlowTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("ItemLink");
    }

    @Override
    public void compile(PageCompiler compiler, LytFlowParent parent, MdxJsxElementFields el) {
        Pair<ResourceLocation, ItemStack> itemAndId = MdxAttrs.getRequiredItemStackAndId(compiler, parent, el);
        if (itemAndId == null) {
            return;
        }
        ResourceLocation id = (ResourceLocation)itemAndId.getLeft();
        ItemStack stack = (ItemStack)itemAndId.getRight();
        PageAnchor linksTo = (PageAnchor)compiler.getIndex(ItemIndex.class).get(id);
        if (linksTo == null && id.m_135827_().equals(compiler.getPageId().m_135827_())) {
            parent.append(compiler.createErrorFlowContent("No page found for item " + id, el));
            return;
        }
        if (linksTo == null || linksTo.anchor() == null && compiler.getPageId().equals((Object)linksTo.pageId())) {
            LytTooltipSpan span = new LytTooltipSpan();
            span.modifyStyle(style -> style.italic(true));
            span.appendComponent((FormattedText)stack.m_41786_());
            span.setTooltip(new ItemTooltip(stack));
            parent.append(span);
        } else {
            LytFlowLink link = new LytFlowLink();
            link.setClickCallback(screen -> screen.navigateTo(linksTo));
            link.appendComponent((FormattedText)stack.m_41786_());
            link.setTooltip(new ItemTooltip(stack));
            parent.append(link);
        }
    }
}

