/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.test.machine;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.abstractions.recipes.IRecipeVisualizer;
import org.zeith.hammerlib.abstractions.recipes.IVisualizedRecipe;
import org.zeith.hammerlib.abstractions.recipes.layout.ISlotBuilder;
import org.zeith.hammerlib.abstractions.recipes.layout.IVisualizerBuilder;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.recipes.BaseRecipe;
import org.zeith.hammerlib.api.recipes.IngredientWithCount;
import org.zeith.hammerlib.api.recipes.SerializableRecipeType;
import org.zeith.hammerlib.client.render.IGuiDrawable;
import org.zeith.hammerlib.core.adapter.recipe.RecipeBuilder;
import org.zeith.hammerlib.core.test.machine.BlockTestMachine;
import org.zeith.hammerlib.core.test.machine.TileTestMachine;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

@SimplyRegister
public class RecipeTestMachine
extends BaseRecipe<RecipeTestMachine> {
    @RegistryName(value="test_machine")
    public static final TestMachineRecipeType TYPE = new TestMachineRecipeType();
    public final IngredientWithCount inputA;
    public final IngredientWithCount inputB;
    public final ItemStack output;
    public final int time;

    public RecipeTestMachine(ResourceLocation id, String group, int time, ItemStack output, IngredientWithCount inputA, IngredientWithCount inputB) {
        super(id, group);
        this.vanillaResult = output;
        if (!inputA.isEmpty()) {
            this.vanillaIngredients.addAll(inputA.applyCount());
        }
        if (!inputB.isEmpty()) {
            this.vanillaIngredients.addAll(inputB.applyCount());
        }
        this.time = time;
        this.inputA = inputA;
        this.inputB = inputB;
        this.output = output;
    }

    @Override
    protected SerializableRecipeType<RecipeTestMachine> getRecipeType() {
        return TYPE;
    }

    public ItemStack getRecipeOutput(TileTestMachine machine) {
        return this.output.m_41777_();
    }

    public int getTime() {
        return this.time;
    }

    public static class TestMachineRecipeType
    extends SerializableRecipeType<RecipeTestMachine> {
        public RecipeTestMachine fromJson(ResourceLocation recipeLoc, JsonObject recipeJson) {
            NonNullList<IngredientWithCount> inputs = TestMachineRecipeType.ingredientsWithCountFromArray(recipeJson.getAsJsonArray("ingredients"));
            return new RecipeTestMachine(recipeLoc, GsonHelper.m_13851_((JsonObject)recipeJson, (String)"group", (String)""), GsonHelper.m_13927_((JsonObject)recipeJson, (String)"time"), TestMachineRecipeType.itemStackFromJson(recipeJson.getAsJsonObject("result")), (IngredientWithCount)inputs.get(0), inputs.size() > 1 ? (IngredientWithCount)inputs.get(1) : IngredientWithCount.EMPTY);
        }

        public void toNetwork(FriendlyByteBuf buf, RecipeTestMachine recipe) {
            recipe.inputA.toNetwork(buf);
            recipe.inputB.toNetwork(buf);
            buf.m_130130_(recipe.time);
            buf.writeItemStack(recipe.output, false);
            buf.m_130070_(recipe.group);
        }

        @Nullable
        public RecipeTestMachine fromNetwork(ResourceLocation recipeLoc, FriendlyByteBuf buf) {
            IngredientWithCount ingrA = IngredientWithCount.fromNetwork(buf);
            IngredientWithCount ingrB = IngredientWithCount.fromNetwork(buf);
            int time = buf.m_130242_();
            ItemStack res = buf.m_130267_();
            String group = buf.m_130277_();
            return new RecipeTestMachine(recipeLoc, group, time, res, ingrA, ingrB);
        }

        @Override
        public void initVisuals(Consumer<IRecipeVisualizer<RecipeTestMachine, ?>> viualizerConsumer) {
            viualizerConsumer.accept(IRecipeVisualizer.simple(VisualizedTestMachine.class, IRecipeVisualizer.groupBuilder().title((Component)BlockTestMachine.TEST_MACHINE.m_49954_()).size(52, 36).icon(IGuiDrawable.ofItem(new ItemStack((ItemLike)BlockTestMachine.TEST_MACHINE))).catalyst(new ItemStack((ItemLike)BlockTestMachine.TEST_MACHINE)).build(), VisualizedTestMachine::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VisualizedTestMachine
    implements IVisualizedRecipe<RecipeTestMachine> {
        final RecipeTestMachine recipe;

        public VisualizedTestMachine(RecipeTestMachine recipe) {
            this.recipe = recipe;
        }

        @Override
        public RecipeTestMachine getRecipe() {
            return this.recipe;
        }

        @Override
        public void setupLayout(IVisualizerBuilder builder) {
            ((ISlotBuilder)builder.addSlot(ISlotBuilder.SlotRole.INPUT, 0, 0).addItemStacks(Stream.of(this.recipe.inputA.input().m_43908_()).peek(s -> s.m_41764_(this.recipe.inputA.count())).toList())).build();
            ((ISlotBuilder)builder.addSlot(ISlotBuilder.SlotRole.INPUT, 0, 18).addItemStacks(Stream.of(this.recipe.inputB.input().m_43908_()).peek(s -> s.m_41764_(this.recipe.inputB.count())).toList())).build();
            ((ISlotBuilder)builder.addSlot(ISlotBuilder.SlotRole.OUTPUT, 36, 9).addItemStack(this.recipe.output)).build();
        }
    }

    public static class TestMachineRecipeBuilder
    extends RecipeBuilder<TestMachineRecipeBuilder> {
        protected IngredientWithCount inputA;
        protected IngredientWithCount inputB;
        protected int time = 100;

        public TestMachineRecipeBuilder(IRecipeRegistrationEvent<Recipe<?>> event) {
            super(event);
        }

        public TestMachineRecipeBuilder time(int time) {
            this.time = time;
            return this;
        }

        @Override
        public TestMachineRecipeBuilder result(ItemStack stack) {
            this.result = stack;
            return this;
        }

        @Override
        public TestMachineRecipeBuilder result(ItemLike provider) {
            this.result = new ItemStack(provider);
            return this;
        }

        @Override
        public TestMachineRecipeBuilder result(ItemLike provider, int count) {
            this.result = new ItemStack(provider, count);
            return this;
        }

        public TestMachineRecipeBuilder top(Object in, int count) {
            this.inputA = this.parseIngredient(in, count);
            return this;
        }

        public TestMachineRecipeBuilder bottom(Object in, int count) {
            this.inputB = this.parseIngredient(in, count);
            return this;
        }

        @Override
        protected void validate() throws IllegalStateException {
            if (this.inputA == null) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a defined input A!");
            }
            if (this.inputB == null) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a defined input B!");
            }
            if (this.result.m_41619_()) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a defined output!");
            }
        }

        @Override
        protected Recipe<?> createRecipe() {
            return new RecipeTestMachine(this.getIdentifier(), this.group, this.time, this.result, this.inputA, this.inputB);
        }
    }
}

