/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.scans;

import java.lang.annotation.ElementType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.core.adapter.RegistryAdapter;
import org.zeith.hammerlib.core.scans.base.IAnnotationScanListener;
import org.zeith.hammerlib.core.scans.base.IScanListener;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

public class ScanTabs {
    public static IScanListener create() {
        return IAnnotationScanListener.forAnnotation(CreativeTab.RegisterTab.class, ElementType.FIELD, ScanTabs::handle);
    }

    private static void handle(ScanDataHelper.ModAwareAnnotationData data) {
        FMLModContainer mc = data.getOwnerMod().orElse(null);
        if (mc == null) {
            return;
        }
        Objects.requireNonNull(mc.getEventBus(), "Mod's event bus (" + mc.getModId() + ")").addListener(e -> {
            Optional<BiConsumer<ResourceLocation, BiConsumer>> registrar = RegistryAdapter.createRegisterer(e, Registries.f_279569_, null);
            registrar.ifPresent(register -> {
                Optional<CreativeTab> tab = ReflectionUtil.getStaticFinalField(data.getOwnerClass(), data.getMemberName());
                tab.ifPresent(t0 -> t0.register(t -> {
                    CreativeModeTab.Builder tabBuilder = CreativeModeTab.builder();
                    t.factory().accept(tabBuilder);
                    CreativeModeTab ct = tabBuilder.m_257652_();
                    register.accept(t.id(), ct);
                    return ct;
                }));
            });
        });
    }
}

