/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.event.LanguageReloadEvent;

public class LanguageAdapter {
    private static final Set<String> modids = Sets.newConcurrentHashSet();

    public static void registerMod(String modid) {
        modids.add(modid);
    }

    public static void reloadLangs(LanguageReloadEvent e) {
        ReloadableResourceManager mgr = HammerLib.PROXY.getResourceManager();
        if (mgr == null) {
            HammerLib.LOG.warn("Failed to reload HammerLib languages due to lack of available ResourceManager");
            return;
        }
        HammerLib.LOG.debug("Reloading HammerLib-enabled language namespaces: " + mgr.m_7187_());
        for (String modId : modids) {
            LanguageAdapter.findFirstExisting((ResourceManager)mgr, new ResourceLocation(modId, "langs/" + e.getLang().toLowerCase() + "._hl"), new ResourceLocation(modId, "lang/" + e.getLang().toLowerCase() + "._hl"), new ResourceLocation(modId, "langs/" + e.getLang().toLowerCase() + ".lang"), new ResourceLocation(modId, "lang/" + e.getLang().toLowerCase() + ".lang")).forEach(langFile -> {
                List resources = mgr.m_213829_(langFile);
                try {
                    boolean logged = false;
                    for (Resource res : resources) {
                        try (Scanner in = new Scanner(res.m_215507_(), StandardCharsets.UTF_8);){
                            if (!logged) {
                                HammerLib.LOG.debug("Hooking HammerLib language adapter for namespace " + modId + ": " + langFile);
                                logged = true;
                            }
                            while (in.hasNextLine()) {
                                String[] kv;
                                String line = in.nextLine();
                                if (line.startsWith("#") || (kv = line.split("=", 2)).length != 2) continue;
                                e.translate(kv[0], kv[1]);
                            }
                        }
                    }
                }
                catch (FileNotFoundException logged) {
                }
                catch (Throwable ex) {
                    HammerLib.LOG.error("Failed to load language file located at " + langFile, ex);
                }
            });
        }
    }

    private static Stream<ResourceLocation> findFirstExisting(ResourceManager mgr, ResourceLocation ... paths) {
        return Stream.of(paths);
    }

    static {
        HammerLib.EVENT_BUS.addListener(LanguageAdapter::reloadLangs);
    }
}

