/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.readers;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.annotations.ide.AllowJS;
import org.zeith.hammerlib.annotations.ide.AllowedValues;
import org.zeith.hammerlib.annotations.ide.Default;
import org.zeith.hammerlib.annotations.ide.FileReference;
import org.zeith.hammerlib.annotations.ide.Namespace;
import org.zeith.hammerlib.annotations.ide.Required;
import org.zeith.hammerlib.annotations.ide.Suggestions;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.FlowguiShaderRegistry;
import org.zeith.hammerlib.client.flowgui.objects.GuiSpriteButtonObject;
import org.zeith.hammerlib.client.flowgui.reader.ComDrivers;
import org.zeith.hammerlib.client.flowgui.reader.DriverContext;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiReader;
import org.zeith.hammerlib.client.flowgui.reader.GuiReader;
import org.zeith.hammerlib.util.java.Suppliers2;
import org.zeith.hammerlib.util.mcf.Resources;

@Namespace(value="hammerlib")
@FlowguiReader(value="sprite_button")
public class FlowguiSpriteButtonReader
extends GuiReader<GuiSpriteButtonObject> {
    @AllowJS
    @FileReference(regex={"^(?<modid>[a-z0-9_.-]+):(?<path>[a-z0-9_./-]+)$", "^(?<path>[a-z0-9_./-]+)$"}, value={"assets/%modid%/%path%", "assets/minecraft/%path%"})
    @AllowedValues(value={"^([a-z0-9_.-]+:[a-z0-9_./-]+)|([a-z0-9_./-]+)$"})
    @Required(value="minecraft:textures/gui/container/furnace.png")
    public static final String KEY_TEXTURE = "src";
    @AllowJS
    @AllowedValues(value={"^([a-z0-9_.-]+:[a-z0-9_./-]+)|([a-z0-9_./-]+)$"})
    @Default(value="minecraft:gui")
    public static final String KEY_SHADER = "shader";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="1")
    public static final String KEY_ALPHA = "alpha";
    @AllowJS
    @AllowedValues(value={"^#[a-fA-F0-9]{1,6}$"})
    @Default(value="#FFFFFF")
    public static final String KEY_BUTTON_COLOR = "button-color";
    @AllowJS
    @AllowedValues(value={"^#[a-fA-F0-9]{1,6}$"})
    @Default(value="#FFFFFF")
    public static final String KEY_TEXT_COLOR = "text-color";
    @AllowJS
    @AllowedValues(value={"^([a-z0-9_.-]+:[a-z0-9_./-]+)|([a-z0-9_./-]+)$"})
    public static final String KEY_PRESS_SOUND = "press-sound";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    public static final String KEY_PRESS_SOUND_PITCH = "press-sound-pitch";
    @AllowJS
    @Default(value="")
    public static final String KEY_LABEL = "label";
    @AllowJS
    @Default(value="(q, self) => {}")
    public static final String KEY_CALLBACK = "callback";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="(q, self) => true")
    public static final String KEY_ENABLED = "enabled";

    @Override
    protected GuiSpriteButtonObject readObject(KeyMap map, String name, IDataNode node) {
        AtomicReference<GuiSpriteButtonObject> self = new AtomicReference<GuiSpriteButtonObject>();
        DriverContext ctx = this.getDriverContext(map, node, self);
        GuiSpriteButtonObject.SpriteButtonBuilder builder = GuiSpriteButtonObject.of(name);
        Set<String> keys = node.keys();
        if (keys.contains(KEY_PRESS_SOUND)) {
            Supplier<String> fac = ComDrivers.readString(ctx, KEY_PRESS_SOUND);
            if (ComDrivers.isConstant(fac)) {
                builder.pressSound((Supplier<SoundEvent>)Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)Resources.location(fac.get()))));
            } else {
                builder.pressSound(Suppliers2.map(fac, s -> SoundEvent.m_262824_((ResourceLocation)Resources.location(s))));
            }
        }
        GuiSpriteButtonObject button = builder.build();
        self.set(button);
        Runnable cbq = ComDrivers.readCallback(ctx, KEY_CALLBACK, false);
        button.callback = b -> cbq.run();
        ComDrivers.driveString(ctx, KEY_TEXTURE, "minecraft:missing", false, str -> {
            button.texture = Resources.locationOrNull(str);
        });
        ComDrivers.driveComponent(ctx, KEY_LABEL, (Component)Component.m_237119_(), false, button::setMessage);
        ComDrivers.driveColor(ctx, KEY_TEXT_COLOR, 0xFFFFFF, false, button::setPackedFGColor);
        ComDrivers.driveColor(ctx, KEY_BUTTON_COLOR, 0xFFFFFF, false, rgb -> {
            button.color = Vec3.m_82501_((int)rgb);
        });
        ComDrivers.driveBool(ctx, KEY_ENABLED, true, false, button::setEnabled);
        ComDrivers.driveFloat(ctx, KEY_ALPHA, Float.valueOf(1.0f), false, alpha -> button.setAlpha(Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f)));
        ComDrivers.driveFloat(ctx, KEY_PRESS_SOUND_PITCH, Float.valueOf(1.0f), false, alpha -> button.setPressSoundPitch(Mth.m_14036_((float)alpha, (float)0.0f, (float)2.0f)));
        ComDrivers.driveString(ctx, KEY_SHADER, "minecraft:gui", false, shader -> {
            button.shader = FlowguiShaderRegistry.get(Resources.locationOrNull(shader));
        });
        return button;
    }
}

