/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.reader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.annotations.ide.AllowJS;
import org.zeith.hammerlib.annotations.ide.AllowedValues;
import org.zeith.hammerlib.annotations.ide.Default;
import org.zeith.hammerlib.annotations.ide.Required;
import org.zeith.hammerlib.api.data.DataNodeTransformer;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.data.FlowQuery;
import org.zeith.hammerlib.client.flowgui.objects.GuiRootObject;
import org.zeith.hammerlib.client.flowgui.objects.RenderHook;
import org.zeith.hammerlib.client.flowgui.reader.Alignment;
import org.zeith.hammerlib.client.flowgui.reader.ComDrivers;
import org.zeith.hammerlib.client.flowgui.reader.DriverContext;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiRegistry;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiTags;
import org.zeith.hammerlib.client.flowgui.reader.JsContext;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.DirectStorage;
import org.zeith.hammerlib.util.java.OptionalBoolean;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.java.itf.FloatSupplier;
import org.zeith.hammerlib.util.math.Point;
import org.zeith.hammerlib.util.mcf.Resources;

public abstract class GuiReader<T extends GuiObject> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GuiReader.class);
    public static final Map<String, String> TAGS_TO_COMPONENTS = (Map)Util.m_137469_(new HashMap(), m -> Arrays.stream(FlowguiTags.class.getDeclaredFields()).filter(f -> String.class.equals(f.getType()) && f.getName().startsWith("COM_")).forEach(f -> ReflectionUtil.fetchValue(f, null, String.class).ifPresent(id -> m.put(f.getName().substring(4), id))));
    @AllowJS
    @AllowedValues(value={"^true|false$"})
    @Default(value="(q) => true")
    public static final String KEY_IF = "if";
    @AllowedValues(value={"^true|false$", "^int$"})
    public static final String KEY_CENTERED = "centered";
    @AllowJS
    @AllowedValues(value={"^-?(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="0")
    public static final String KEY_X = "x";
    @AllowJS
    @AllowedValues(value={"^-?(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="0")
    public static final String KEY_Y = "y";
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    public static final String KEY_WIDTH = "width";
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    public static final String KEY_HEIGHT = "height";
    @AllowJS
    @AllowedValues(value={"^-?(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="0")
    public static final String KEY_ROTATION = "rotation";
    @AllowJS
    @AllowedValues(value={"^-?(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="1")
    public static final String KEY_SCALE_UNIFIED = "scale";
    @AllowJS
    @AllowedValues(value={"^-?(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="1")
    public static final String KEY_SCALE_X = "scale-x";
    @AllowJS
    @AllowedValues(value={"^-?(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="1")
    public static final String KEY_SCALE_Y = "scale-y";
    @AllowJS
    @AllowedValues(value={"^-?(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="1")
    public static final String KEY_SCALE_Z = "scale-z";
    @AllowedValues(value={"^true|false$"})
    public static final String KEY_PIVOT_CENTER = "pivot-centered";
    @AllowJS
    @AllowedValues(value={"^-?(0|[1-9]\\d*)(\\.\\d+)?$"})
    public static final String KEY_PIVOT_X = "pivot-x";
    @AllowJS
    @AllowedValues(value={"^-?(0|[1-9]\\d*)(\\.\\d+)?$"})
    public static final String KEY_PIVOT_Y = "pivot-y";
    @AllowedValues(value={"^start$", "^left$", "^center$", "^right$", "^end$"})
    @Default(value="left")
    public static final String KEY_ALIGN_X = "align-x";
    @AllowedValues(value={"^start$", "^top$", "^up$", "^center$", "^bottom$", "^down$", "^end$"})
    @Default(value="left")
    public static final String KEY_ALIGN_Y = "align-y";
    @AllowedValues(value={"^([a-z0-9_.-]+:[a-z0-9_./-]+)|([a-z0-9_./-]+)$"})
    @Required(value="")
    public static final String KEY_CLASS = "class";
    @AllowedValues(value={"^[^/]+$"})
    public static final String KEY_ID = "id";

    protected abstract T readObject(KeyMap var1, String var2, IDataNode var3);

    protected void handleExtraNodes(T object, KeyMap map, IDataNode node, FloatSupplier parentWidth, FloatSupplier parentHeight) {
    }

    protected void finishBuilding(T object, KeyMap map) {
    }

    protected Supplier<RuntimeException> invalidField(IDataNode node, String fieldName) {
        return () -> new IllegalArgumentException("Field " + fieldName + " has invalid data (" + node.getString(fieldName) + ")!");
    }

    public final T read(KeyMap map, IDataNode node$, FloatSupplier parentWidth, FloatSupplier parentHeight) {
        AtomicReference<T> self;
        DriverContext ctx;
        Object id = node$.getString(KEY_ID);
        if (id == null || ((String)id).isBlank()) {
            RandomSource rng = map.getOrSupply(FlowguiRegistry.NAMEGEN_RANDOM, RandomSource::m_216327_);
            id = "gen:" + new UUID(rng.m_188505_(), rng.m_188505_());
        }
        if (ComDrivers.readBoolean(ctx = this.getDriverContext(map, node$, self = new AtomicReference<T>()), KEY_IF).get() == OptionalBoolean.OPTIONAL_FALSE) {
            return null;
        }
        Object obj = this.readObject(map, (String)id, node$);
        if (obj == null) {
            return null;
        }
        self.set(obj);
        ((GuiObject)obj).finishBuilding.add(() -> this.finishBuilding(obj, map));
        Set<String> keys = node$.keys();
        if (keys.contains(KEY_WIDTH)) {
            node$.getFloat(KEY_WIDTH).ifPresent(((GuiObject)obj).elementWidth::set);
        }
        if (keys.contains(KEY_HEIGHT)) {
            node$.getFloat(KEY_HEIGHT).ifPresent(((GuiObject)obj).elementHeight::set);
        }
        boolean[] scaledAxis = this.driveScale(ctx);
        this.drivePosition(ctx, parentWidth, parentHeight, scaledAxis);
        ComDrivers.driveFloat(ctx, KEY_ROTATION, Float.valueOf(0.0f), false, ((GuiObject)obj).elementRotation::set);
        this.drivePivot(ctx, scaledAxis);
        int childCount = node$.length();
        block12: for (int i = 0; i < childCount; ++i) {
            Object attr = node$.get(i);
            if (!(attr instanceof IDataNode)) continue;
            IDataNode node = (IDataNode)attr;
            String cName = node.getMyName().toLowerCase(Locale.ROOT);
            String tagName = TAGS_TO_COMPONENTS.get(cName);
            if (tagName != null) {
                IDataNode node2 = DataNodeTransformer.convertToComponent(node, Resources.location(tagName));
                Optional<GuiObject> child2 = FlowguiRegistry.read(map, node2, () -> obj.getUnscaledWidth(), () -> obj.getUnscaledHeight());
                if (child2 != null) {
                    child2.ifPresent(arg_0 -> obj.addChild(arg_0));
                    continue;
                }
                HammerLib.LOG.warn("Failed to read Flowgui {} component: {}", (Object)tagName, (Object)ComDrivers.readableName(node));
                continue;
            }
            switch (cName) {
                case "com": {
                    Optional<GuiObject> child3 = FlowguiRegistry.read(map, node, () -> obj.getUnscaledWidth(), () -> obj.getUnscaledHeight());
                    if (child3 != null) {
                        child3.ifPresent(arg_0 -> obj.addChild(arg_0));
                        continue block12;
                    }
                    HammerLib.LOG.warn("Failed to read Flowgui component: {}", (Object)ComDrivers.readableName(node));
                    continue block12;
                }
                case "import": {
                    IDataNode node2 = DataNodeTransformer.convertToComponent(node, HLConstants.id("empty"));
                    Optional<GuiObject> childOpt = FlowguiRegistry.read(map, node2, () -> obj.getUnscaledWidth(), () -> obj.getUnscaledHeight());
                    if (childOpt != null) {
                        KeyMap childContext = KeyMap.createHash().withAll(map);
                        childOpt.ifPresent(child -> {
                            GuiRootObject scene;
                            obj.addChild((GuiObject)child);
                            ResourceLocation from = Resources.locationOrNull(node.getString("from"));
                            GuiRootObject guiRootObject = from != null ? FlowguiRegistry.readRoot(from, childContext, child::getUnscaledWidth, child::getUnscaledHeight) : (scene = null);
                            if (scene != null) {
                                if (child.elementWidth.get().floatValue() <= 0.0f) {
                                    child.elementWidth.set(Float.valueOf(scene.getUnscaledWidth()));
                                }
                                if (child.elementHeight.get().floatValue() <= 0.0f) {
                                    child.elementHeight.set(Float.valueOf(scene.getUnscaledHeight()));
                                }
                                ArrayList chs = new ArrayList();
                                scene.getChildren().forEach(chs::add);
                                for (GuiObject ch : chs) {
                                    scene.removeChild(ch.getName());
                                    child.addChild(ch);
                                }
                            } else {
                                HammerLib.LOG.warn("Failed to read Flowgui import: {}", (Object)ComDrivers.readableName(node));
                            }
                        });
                        continue block12;
                    }
                    HammerLib.LOG.warn("Failed to read Flowgui import as placeholder object: {}", (Object)ComDrivers.readableName(node));
                    continue block12;
                }
                case "root": {
                    HammerLib.LOG.error("Attempted to insert {} inside of component {}. This is not allowed!", (Object)ComDrivers.readableName(node), (Object)ComDrivers.readableName(node$));
                    continue block12;
                }
                case "script": {
                    continue block12;
                }
                default: {
                    this.handleExtraNodes(obj, map, node, parentWidth, parentHeight);
                }
            }
        }
        return obj;
    }

    private boolean[] driveScale(DriverContext ctx) {
        GuiObject obj = ctx.self();
        AtomicReference<Float> scaleX = new AtomicReference<Float>(Float.valueOf(1.0f));
        AtomicReference<Float> scaleY = new AtomicReference<Float>(Float.valueOf(1.0f));
        AtomicReference<Float> scaleZ = new AtomicReference<Float>(Float.valueOf(1.0f));
        AtomicReference<Float> mainScale = new AtomicReference<Float>(Float.valueOf(1.0f));
        boolean scaledAll = ComDrivers.driveFloat(ctx, KEY_SCALE_UNIFIED, Float.valueOf(1.0f), false, s -> {
            mainScale.set(Float.valueOf(s));
            obj.elementScale.set(new Vec3((double)(((Float)scaleX.get()).floatValue() * s), (double)(((Float)scaleY.get()).floatValue() * s), (double)(((Float)scaleZ.get()).floatValue() * s)));
        });
        boolean scaledX = ComDrivers.driveFloat(ctx, KEY_SCALE_X, Float.valueOf(1.0f), false, s -> {
            scaleX.set(Float.valueOf(s));
            DirectStorage<Vec3> es = obj.elementScale;
            Vec3 vec = es.get();
            es.set(new Vec3((double)(s * ((Float)mainScale.get()).floatValue()), vec.f_82480_, vec.f_82481_));
        });
        boolean scaledY = ComDrivers.driveFloat(ctx, KEY_SCALE_Y, Float.valueOf(1.0f), false, s -> {
            scaleY.set(Float.valueOf(s));
            DirectStorage<Vec3> es = obj.elementScale;
            Vec3 vec = es.get();
            es.set(new Vec3(vec.f_82479_, (double)(s * ((Float)mainScale.get()).floatValue()), vec.f_82481_));
        });
        ComDrivers.driveFloat(ctx, KEY_SCALE_Z, Float.valueOf(1.0f), false, s -> {
            scaleZ.set(Float.valueOf(s));
            DirectStorage<Vec3> es = obj.elementScale;
            Vec3 vec = es.get();
            es.set(new Vec3(vec.f_82479_, vec.f_82480_, (double)(s * ((Float)mainScale.get()).floatValue())));
        });
        return new boolean[]{scaledAll || scaledX, scaledAll || scaledY};
    }

    private void drivePosition(DriverContext ctx, FloatSupplier parentWidth, FloatSupplier parentHeight, boolean[] scaledAxis) {
        Supplier<Alignment> alX = Alignment.readX(ctx.query(), ctx.getString(KEY_ALIGN_X), Alignment.START);
        Supplier<Alignment> alY = Alignment.readY(ctx.query(), ctx.getString(KEY_ALIGN_Y), Alignment.START);
        int centering = ctx.getBoolean(KEY_CENTERED) ? 1 : ("int".equalsIgnoreCase(ctx.getString(KEY_CENTERED)) ? 2 : 0);
        GuiObject obj = ctx.self();
        ComDrivers.driveFloat(ctx, KEY_X, Float.valueOf(0.0f), scaledAxis[0], x -> obj.elementPosition.apply(arg_0 -> GuiReader.lambda$drivePosition$11((Supplier)alX, x, parentWidth, obj, arg_0)));
        ComDrivers.driveFloat(ctx, KEY_Y, Float.valueOf(0.0f), scaledAxis[1], y -> obj.elementPosition.apply(arg_0 -> GuiReader.lambda$drivePosition$13((Supplier)alY, y, parentHeight, obj, arg_0)));
        switch (centering) {
            case 1: {
                obj.centered(parentWidth.getAsFloat(), parentHeight.getAsFloat());
                obj.onPreRender((f, mouse) -> obj.centered(parentWidth.getAsFloat(), parentHeight.getAsFloat()));
                break;
            }
            case 2: {
                obj.centered((int)parentWidth.getAsFloat(), (int)parentHeight.getAsFloat());
                obj.onPreRender((f, mouse) -> obj.centered((int)parentWidth.getAsFloat(), (int)parentHeight.getAsFloat()));
            }
        }
    }

    private void drivePivot(DriverContext ctx, boolean[] scaledAxis) {
        GuiObject obj = ctx.self();
        if (ctx.getBoolean(KEY_PIVOT_CENTER)) {
            obj.pivotAtCenter();
            if (scaledAxis[0] || scaledAxis[1]) {
                obj.onPreRender((f, mouse) -> obj.pivotAtCenter());
            }
        }
        ComDrivers.driveFloat(ctx, KEY_PIVOT_X, null, false, x -> obj.elementPivot.apply(p -> p.withX(x)));
        ComDrivers.driveFloat(ctx, KEY_PIVOT_Y, null, false, y -> obj.elementPivot.apply(p -> p.withY(y)));
    }

    private JsContext getJSContext$(KeyMap map) {
        return map.get(FlowguiRegistry.JS_CONTEXT);
    }

    private FlowQuery getQuery$(KeyMap map) {
        return map.get(FlowguiRegistry.QUERY);
    }

    protected DriverContext getDriverContext(KeyMap map, IDataNode node, GuiObject myself) {
        return this.getDriverContext(map, node, Cast.constant(myself), myself::onPreRender);
    }

    protected <R extends GuiObject> DriverContext getDriverContext(KeyMap map, IDataNode node, AtomicReference<R> futureSelf) {
        return this.getDriverContext(map, node, futureSelf::get, h -> {
            GuiObject o = (GuiObject)futureSelf.get();
            if (o != null) {
                o.onPreRender((RenderHook)h);
            }
        });
    }

    protected DriverContext getDriverContext(KeyMap map, IDataNode node, Supplier<GuiObject> myself, Consumer<RenderHook> onPreRender) {
        return new DriverContext(this.getJSContext$(map), this.getQuery$(map), node, myself, onPreRender);
    }

    private static /* synthetic */ Point lambda$drivePosition$13(Supplier alY, float y, FloatSupplier parentHeight, GuiObject obj, Point pos0) {
        return pos0.withY(((Alignment)((Object)alY.get())).apply(y, parentHeight.getAsFloat(), obj.getScaledHeight()));
    }

    private static /* synthetic */ Point lambda$drivePosition$11(Supplier alX, float x, FloatSupplier parentWidth, GuiObject obj, Point pos0) {
        return pos0.withX(((Alignment)((Object)alX.get())).apply(x, parentWidth.getAsFloat(), obj.getScaledWidth()));
    }
}

