/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects.dataStreams;

import DistantHorizons.libraries.jpountz.lz4.LZ4Factory;
import DistantHorizons.libraries.jpountz.lz4.LZ4FrameOutputStream;
import DistantHorizons.libraries.jpountz.xxhash.XXHashFactory;
import com.github.luben.zstd.ZstdOutputStream;
import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.util.objects.dataStreams.LzmaArrayCache;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.ResettableArrayCache;
import org.tukaani.xz.XZOutputStream;

public class DhDataOutputStream
extends DataOutputStream {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ThreadLocal<ResettableArrayCache> LZMA_RESETTABLE_ARRAY_CACHE_GETTER = ThreadLocal.withInitial(() -> new ResettableArrayCache(new LzmaArrayCache()));

    public DhDataOutputStream(OutputStream stream, EDhApiDataCompressionMode compressionMode) throws IOException {
        super(DhDataOutputStream.warpStream(new BufferedOutputStream(stream), compressionMode));
    }

    private static OutputStream warpStream(OutputStream stream, EDhApiDataCompressionMode compressionMode) throws IOException {
        try {
            switch (compressionMode) {
                case UNCOMPRESSED: {
                    return stream;
                }
                case Z_STD: {
                    return new ZstdOutputStream(stream, 3, true, true);
                }
                case LZ4: {
                    return new LZ4FrameOutputStream(stream, LZ4FrameOutputStream.BLOCKSIZE.SIZE_64KB, -1L, LZ4Factory.fastestInstance().fastCompressor(), XXHashFactory.fastestInstance().hash32(), LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE);
                }
                case LZMA2: {
                    ResettableArrayCache arrayCache = LZMA_RESETTABLE_ARRAY_CACHE_GETTER.get();
                    arrayCache.reset();
                    return new XZOutputStream(stream, new LZMA2Options(3), 4, (ArrayCache)arrayCache);
                }
            }
            throw new IllegalArgumentException("No compressor defined for [" + (Object)((Object)compressionMode) + "]");
        }
        catch (Error e) {
            LOGGER.error("Unexpected error when wrapping DhDataInputStream, error: [" + e.getMessage() + "].", (Throwable)e);
            throw e;
        }
    }
}

