/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.eventHandlers.presets;

import com.seibel.distanthorizons.api.enums.config.EDhApiHorizontalQuality;
import com.seibel.distanthorizons.api.enums.config.EDhApiMaxHorizontalResolution;
import com.seibel.distanthorizons.api.enums.config.EDhApiMcRenderingFadeMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiVerticalQuality;
import com.seibel.distanthorizons.api.enums.config.quickOptions.EDhApiQualityPreset;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiTransparency;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigPresetOptions;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.AbstractPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.config.types.AbstractConfigBase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenderQualityPresetConfigEventHandler
extends AbstractPresetConfigEventHandler<EDhApiQualityPreset> {
    public static final RenderQualityPresetConfigEventHandler INSTANCE = new RenderQualityPresetConfigEventHandler();
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConfigPresetOptions<EDhApiQualityPreset, EDhApiMaxHorizontalResolution> drawResolution = new ConfigPresetOptions<EDhApiQualityPreset, EDhApiMaxHorizontalResolution>(Config.Client.Advanced.Graphics.Quality.maxHorizontalResolution, new HashMap<EDhApiQualityPreset, EDhApiMaxHorizontalResolution>(){
        {
            this.put(EDhApiQualityPreset.MINIMUM, EDhApiMaxHorizontalResolution.TWO_BLOCKS);
            this.put(EDhApiQualityPreset.LOW, EDhApiMaxHorizontalResolution.BLOCK);
            this.put(EDhApiQualityPreset.MEDIUM, EDhApiMaxHorizontalResolution.BLOCK);
            this.put(EDhApiQualityPreset.HIGH, EDhApiMaxHorizontalResolution.BLOCK);
            this.put(EDhApiQualityPreset.EXTREME, EDhApiMaxHorizontalResolution.BLOCK);
        }
    });
    private final ConfigPresetOptions<EDhApiQualityPreset, EDhApiVerticalQuality> verticalQuality = new ConfigPresetOptions<EDhApiQualityPreset, EDhApiVerticalQuality>(Config.Client.Advanced.Graphics.Quality.verticalQuality, new HashMap<EDhApiQualityPreset, EDhApiVerticalQuality>(){
        {
            this.put(EDhApiQualityPreset.MINIMUM, EDhApiVerticalQuality.HEIGHT_MAP);
            this.put(EDhApiQualityPreset.LOW, EDhApiVerticalQuality.LOW);
            this.put(EDhApiQualityPreset.MEDIUM, EDhApiVerticalQuality.MEDIUM);
            this.put(EDhApiQualityPreset.HIGH, EDhApiVerticalQuality.HIGH);
            this.put(EDhApiQualityPreset.EXTREME, EDhApiVerticalQuality.EXTREME);
        }
    });
    private final ConfigPresetOptions<EDhApiQualityPreset, EDhApiHorizontalQuality> horizontalQuality = new ConfigPresetOptions<EDhApiQualityPreset, EDhApiHorizontalQuality>(Config.Client.Advanced.Graphics.Quality.horizontalQuality, new HashMap<EDhApiQualityPreset, EDhApiHorizontalQuality>(){
        {
            this.put(EDhApiQualityPreset.MINIMUM, EDhApiHorizontalQuality.LOWEST);
            this.put(EDhApiQualityPreset.LOW, EDhApiHorizontalQuality.LOW);
            this.put(EDhApiQualityPreset.MEDIUM, EDhApiHorizontalQuality.MEDIUM);
            this.put(EDhApiQualityPreset.HIGH, EDhApiHorizontalQuality.HIGH);
            this.put(EDhApiQualityPreset.EXTREME, EDhApiHorizontalQuality.EXTREME);
        }
    });
    private final ConfigPresetOptions<EDhApiQualityPreset, EDhApiTransparency> transparency = new ConfigPresetOptions<EDhApiQualityPreset, EDhApiTransparency>(Config.Client.Advanced.Graphics.Quality.transparency, new HashMap<EDhApiQualityPreset, EDhApiTransparency>(){
        {
            this.put(EDhApiQualityPreset.MINIMUM, EDhApiTransparency.DISABLED);
            this.put(EDhApiQualityPreset.LOW, EDhApiTransparency.DISABLED);
            this.put(EDhApiQualityPreset.MEDIUM, EDhApiTransparency.COMPLETE);
            this.put(EDhApiQualityPreset.HIGH, EDhApiTransparency.COMPLETE);
            this.put(EDhApiQualityPreset.EXTREME, EDhApiTransparency.COMPLETE);
        }
    });
    private final ConfigPresetOptions<EDhApiQualityPreset, Boolean> ssaoEnabled = new ConfigPresetOptions<EDhApiQualityPreset, Boolean>(Config.Client.Advanced.Graphics.Ssao.enableSsao, new HashMap<EDhApiQualityPreset, Boolean>(){
        {
            this.put(EDhApiQualityPreset.MINIMUM, false);
            this.put(EDhApiQualityPreset.LOW, false);
            this.put(EDhApiQualityPreset.MEDIUM, true);
            this.put(EDhApiQualityPreset.HIGH, true);
            this.put(EDhApiQualityPreset.EXTREME, true);
        }
    });
    private final ConfigPresetOptions<EDhApiQualityPreset, EDhApiMcRenderingFadeMode> vanillaFade = new ConfigPresetOptions<EDhApiQualityPreset, EDhApiMcRenderingFadeMode>(Config.Client.Advanced.Graphics.Quality.vanillaFadeMode, new HashMap<EDhApiQualityPreset, EDhApiMcRenderingFadeMode>(){
        {
            this.put(EDhApiQualityPreset.MINIMUM, EDhApiMcRenderingFadeMode.NONE);
            this.put(EDhApiQualityPreset.LOW, EDhApiMcRenderingFadeMode.SINGLE_PASS);
            this.put(EDhApiQualityPreset.MEDIUM, EDhApiMcRenderingFadeMode.DOUBLE_PASS);
            this.put(EDhApiQualityPreset.HIGH, EDhApiMcRenderingFadeMode.DOUBLE_PASS);
            this.put(EDhApiQualityPreset.EXTREME, EDhApiMcRenderingFadeMode.DOUBLE_PASS);
        }
    });
    private final ConfigPresetOptions<EDhApiQualityPreset, Boolean> dhDither = new ConfigPresetOptions<EDhApiQualityPreset, Boolean>(Config.Client.Advanced.Graphics.Quality.ditherDhFade, new HashMap<EDhApiQualityPreset, Boolean>(){
        {
            this.put(EDhApiQualityPreset.MINIMUM, false);
            this.put(EDhApiQualityPreset.LOW, true);
            this.put(EDhApiQualityPreset.MEDIUM, true);
            this.put(EDhApiQualityPreset.HIGH, true);
            this.put(EDhApiQualityPreset.EXTREME, true);
        }
    });
    private final ConfigPresetOptions<EDhApiQualityPreset, Boolean> caveCulling = new ConfigPresetOptions<EDhApiQualityPreset, Boolean>(Config.Client.Advanced.Graphics.Culling.enableCaveCulling, new HashMap<EDhApiQualityPreset, Boolean>(){
        {
            this.put(EDhApiQualityPreset.MINIMUM, true);
            this.put(EDhApiQualityPreset.LOW, true);
            this.put(EDhApiQualityPreset.MEDIUM, true);
            this.put(EDhApiQualityPreset.HIGH, false);
            this.put(EDhApiQualityPreset.EXTREME, false);
        }
    });
    private final ConfigPresetOptions<EDhApiQualityPreset, Integer> biomeBlending = new ConfigPresetOptions<EDhApiQualityPreset, Integer>(Config.Client.Advanced.Graphics.Quality.lodBiomeBlending, new HashMap<EDhApiQualityPreset, Integer>(){
        {
            this.put(EDhApiQualityPreset.MINIMUM, 0);
            this.put(EDhApiQualityPreset.LOW, 1);
            this.put(EDhApiQualityPreset.MEDIUM, 3);
            this.put(EDhApiQualityPreset.HIGH, 3);
            this.put(EDhApiQualityPreset.EXTREME, 3);
        }
    });

    private RenderQualityPresetConfigEventHandler() {
        this.configList.add(this.drawResolution);
        this.configList.add(this.verticalQuality);
        this.configList.add(this.horizontalQuality);
        this.configList.add(this.transparency);
        this.configList.add(this.ssaoEnabled);
        this.configList.add(this.vanillaFade);
        this.configList.add(this.dhDither);
        this.configList.add(this.caveCulling);
        this.configList.add(this.biomeBlending);
        for (ConfigPresetOptions config : this.configList) {
            new ConfigChangeListener<Object>(config.configEntry, val -> this.onConfigValueChanged());
        }
    }

    @Override
    protected AbstractConfigBase<EDhApiQualityPreset> getPresetConfigEntry() {
        return Config.Client.qualityPresetSetting;
    }

    @Override
    protected List<EDhApiQualityPreset> getPresetEnumList() {
        return Arrays.asList(EDhApiQualityPreset.values());
    }

    @Override
    protected EDhApiQualityPreset getCustomPresetEnum() {
        return EDhApiQualityPreset.CUSTOM;
    }
}

