/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdIOException;
import com.github.luben.zstd.util.Native;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ZstdOutputStreamNoFinalizer
extends FilterOutputStream {
    private final long stream = ZstdOutputStreamNoFinalizer.createCStream();
    private long srcPos = 0L;
    private long dstPos = 0L;
    private final BufferPool bufferPool;
    private final ByteBuffer dstByteBuffer;
    private final byte[] dst;
    private boolean isClosed = false;
    private static final int dstSize;
    private boolean closeFrameOnFlush = false;
    private boolean frameClosed = true;
    private boolean frameStarted = false;

    public static native long recommendedCOutSize();

    private static native long createCStream();

    private static native int freeCStream(long var0);

    private native int resetCStream(long var1);

    private native int compressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    private native int flushStream(long var1, byte[] var3, int var4);

    private native int endStream(long var1, byte[] var3, int var4);

    public ZstdOutputStreamNoFinalizer(OutputStream outputStream, int i) throws IOException {
        this(outputStream, NoPool.INSTANCE);
        Zstd.setCompressionLevel(this.stream, i);
    }

    public ZstdOutputStreamNoFinalizer(OutputStream outputStream) throws IOException {
        this(outputStream, NoPool.INSTANCE);
    }

    public ZstdOutputStreamNoFinalizer(OutputStream outputStream, BufferPool bufferPool, int i) throws IOException {
        this(outputStream, bufferPool);
        Zstd.setCompressionLevel(this.stream, i);
    }

    public ZstdOutputStreamNoFinalizer(OutputStream outputStream, BufferPool bufferPool) throws IOException {
        super(outputStream);
        this.bufferPool = bufferPool;
        this.dstByteBuffer = Zstd.getArrayBackedBuffer(bufferPool, dstSize);
        this.dst = this.dstByteBuffer.array();
    }

    public synchronized ZstdOutputStreamNoFinalizer setChecksum(boolean bl) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionChecksums(this.stream, bl);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setLevel(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionLevel(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setLong(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionLong(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setWorkers(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionWorkers(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setOverlapLog(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionOverlapLog(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setJobSize(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionJobSize(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setTargetLength(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionTargetLength(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setMinMatch(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionMinMatch(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setSearchLog(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionSearchLog(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setChainLog(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionChainLog(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setHashLog(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionHashLog(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setWindowLog(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionWindowLog(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setStrategy(int i) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.setCompressionStrategy(this.stream, i);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setCloseFrameOnFlush(boolean bl) {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        this.closeFrameOnFlush = bl;
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setDict(byte[] bs) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.loadDictCompress(this.stream, bs, bs.length);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setDict(ZstdDictCompress zstdDictCompress) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n = Zstd.loadFastDictCompress(this.stream, zstdDictCompress);
        if (Zstd.isError(n)) {
            throw new ZstdIOException(n);
        }
        return this;
    }

    @Override
    public synchronized void write(byte[] bs, int i, int j) throws IOException {
        int n;
        if (this.isClosed) {
            throw new IOException("StreamClosed");
        }
        if (this.frameClosed) {
            n = this.resetCStream(this.stream);
            if (Zstd.isError(n)) {
                throw new ZstdIOException(n);
            }
            this.frameClosed = false;
            this.frameStarted = true;
        }
        n = i + j;
        this.srcPos = i;
        while (this.srcPos < (long)n) {
            int n2 = this.compressStream(this.stream, this.dst, dstSize, bs, n);
            if (Zstd.isError(n2)) {
                throw new ZstdIOException(n2);
            }
            if (this.dstPos <= 0L) continue;
            this.out.write(this.dst, 0, (int)this.dstPos);
        }
    }

    @Override
    public void write(int i) throws IOException {
        byte[] byArray = new byte[]{(byte)i};
        this.write(byArray, 0, 1);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("StreamClosed");
        }
        if (!this.frameClosed) {
            if (this.closeFrameOnFlush) {
                int n;
                do {
                    if (Zstd.isError(n = this.endStream(this.stream, this.dst, dstSize))) {
                        throw new ZstdIOException(n);
                    }
                    this.out.write(this.dst, 0, (int)this.dstPos);
                } while (n > 0);
                this.frameClosed = true;
            } else {
                int n;
                do {
                    if (Zstd.isError(n = this.flushStream(this.stream, this.dst, dstSize))) {
                        throw new ZstdIOException(n);
                    }
                    this.out.write(this.dst, 0, (int)this.dstPos);
                } while (n > 0);
            }
            this.out.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.close(true);
    }

    public synchronized void closeWithoutClosingParentStream() throws IOException {
        this.close(false);
    }

    private void close(boolean bl) throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            int n;
            if (!this.frameStarted) {
                n = this.resetCStream(this.stream);
                if (Zstd.isError(n)) {
                    throw new ZstdIOException(n);
                }
                this.frameClosed = false;
            }
            if (!this.frameClosed) {
                do {
                    if (Zstd.isError(n = this.endStream(this.stream, this.dst, dstSize))) {
                        throw new ZstdIOException(n);
                    }
                    this.out.write(this.dst, 0, (int)this.dstPos);
                } while (n > 0);
            }
            if (bl) {
                this.out.close();
            }
        }
        finally {
            this.isClosed = true;
            this.bufferPool.release(this.dstByteBuffer);
            ZstdOutputStreamNoFinalizer.freeCStream(this.stream);
        }
    }

    static {
        Native.load();
        dstSize = (int)ZstdOutputStreamNoFinalizer.recommendedCOutSize();
    }
}

