/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.entity.InfinityTridentEntity;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemInfinityTrident
extends ItemInfinity {
    private static String LOYALTY_NBT = "Loyalty";
    private static String RIPTIDE_NBT = "Riptide";
    private static String CHANNELING_NBT = "Channeling";
    private static int LOYALTY_MAX = 5;
    private static int RIPTIDE_MAX = 5;
    public static int POWER_CONSUMPTION = 100000;
    public static int FUEL_CONSUMPTION = 30;

    public ItemInfinityTrident(TitaniumTab group) {
        super("infinity_trident", group, new Item.Properties().m_41487_(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, true);
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        super.addNbt(stack, power, fuel, special);
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_(LOYALTY_NBT, 0);
        nbt.m_128405_(RIPTIDE_NBT, 0);
        nbt.m_128379_(CHANNELING_NBT, false);
        stack.m_41751_(nbt);
    }

    @Override
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 36000;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (EnchantmentHelper.m_44932_((ItemStack)itemstack) > 0 && !playerIn.m_20070_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (!playerIn.m_6144_()) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.equals(Enchantments.f_44955_) || enchantment.equals(Enchantments.f_44957_) || enchantment.equals(Enchantments.f_44958_)) {
            return false;
        }
        return Items.f_42713_.canApplyAtEnchantingTable(new ItemStack((ItemLike)Items.f_42713_), enchantment);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerentity = (Player)entityLiving;
            int i = this.m_8105_(stack) - timeLeft;
            if (i >= 10) {
                int riptideModifier = this.getCurrentRiptide(stack);
                if (riptideModifier <= 0 && this.enoughFuel(stack) && !worldIn.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)playerentity, player -> player.m_21190_(entityLiving.m_7655_()));
                    if (riptideModifier == 0) {
                        this.consumeFuel(stack);
                        InfinityTridentEntity tridententity = new InfinityTridentEntity(worldIn, (LivingEntity)playerentity, stack);
                        tridententity.m_37251_((Entity)playerentity, playerentity.f_19858_, playerentity.f_19857_, 0.0f, 2.5f + (float)riptideModifier * 0.5f, 1.0f);
                        if (playerentity.f_36077_.f_35937_) {
                            tridententity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        worldIn.m_7967_((Entity)tridententity);
                        worldIn.m_6269_((Player)null, (Entity)tridententity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!playerentity.f_36077_.f_35937_) {
                            playerentity.f_36093_.m_36057_(stack);
                        }
                    }
                }
                playerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (riptideModifier > 0 && this.enoughFuel(stack)) {
                    float f7 = playerentity.f_19857_;
                    float f = playerentity.f_19858_;
                    float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)riptideModifier * 2.0f) / 4.0f);
                    playerentity.m_5997_((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    playerentity.m_204079_(20);
                    if (playerentity.m_20096_()) {
                        playerentity.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = riptideModifier >= 3 ? SoundEvents.f_12519_ : (riptideModifier == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    worldIn.m_6269_((Player)null, (Entity)playerentity, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.consumeFuel(stack);
                }
            }
        }
    }

    public int getCurrentLoyalty(ItemStack stack) {
        return stack.m_41784_().m_128451_(LOYALTY_NBT);
    }

    public int getMaxLoyalty(ItemStack stack) {
        InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityTrident.getPowerFromStack(stack)).getLeft());
        return Math.min(Math.max(0, infinityTier.getRadius() - 1), LOYALTY_MAX);
    }

    public void setLoyalty(ItemStack stack, int level) {
        stack.m_41784_().m_128405_(LOYALTY_NBT, level);
    }

    public int getCurrentRiptide(ItemStack stack) {
        return stack.m_41784_().m_128451_(RIPTIDE_NBT);
    }

    public int getMaxRiptide(ItemStack stack) {
        InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityTrident.getPowerFromStack(stack)).getLeft());
        return Math.min(Math.max(0, infinityTier.getRadius() - 1), RIPTIDE_MAX);
    }

    public void setRiptide(ItemStack stack, int level) {
        stack.m_41784_().m_128405_(RIPTIDE_NBT, level);
    }

    public boolean getCurrentChanneling(ItemStack stack) {
        return stack.m_41784_().m_128471_(CHANNELING_NBT);
    }

    public boolean canChanneling(ItemStack stack) {
        return ((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityTrident.getPowerFromStack(stack)).getLeft())).getRadius() >= 4;
    }

    public void setChanneling(ItemStack stack, boolean enabled) {
        stack.m_41784_().m_128379_(CHANNELING_NBT, enabled);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        List<IFactory<? extends IScreenAddon>> factory = super.getScreenAddons(stack);
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52, 14, 14, FacingUtil.Sideness.RIGHT).setId(4))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52, 14, 14, FacingUtil.Sideness.LEFT).setId(5))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56, false){

            public String getText() {
                return ChatFormatting.DARK_GRAY + Component.m_237115_((String)"enchantment.minecraft.loyalty").m_130946_(": ").m_130946_(ItemInfinityTrident.this.getCurrentLoyalty((ItemStack)stack.get()) + "/" + ItemInfinityTrident.this.getMaxLoyalty((ItemStack)stack.get())).getString();
            }
        }));
        int y = 16;
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52 + y, 14, 14, FacingUtil.Sideness.RIGHT).setId(6))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52 + y, 14, 14, FacingUtil.Sideness.LEFT).setId(7))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56 + y, false){

            public String getText() {
                return ChatFormatting.DARK_GRAY + Component.m_237115_((String)"enchantment.minecraft.riptide").m_130946_(": ").m_130946_(ItemInfinityTrident.this.getCurrentRiptide((ItemStack)stack.get()) + "/" + ItemInfinityTrident.this.getMaxRiptide((ItemStack)stack.get())).getString();
            }
        }));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new StateButtonAddon(new ButtonComponent(54, 52 + y * 2, 14, 14).setId(8), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0])}){

            public int getState() {
                return ItemInfinityTrident.this.getCurrentChanneling((ItemStack)stack.get()) ? 0 : 1;
            }
        }));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon(ChatFormatting.DARK_GRAY + Component.m_237115_((String)"enchantment.minecraft.channeling").getString(), 72, 56 + y * 2, false)));
        return factory;
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        ItemStack stack = playerEntity.m_21120_(InteractionHand.MAIN_HAND);
        int current = this.getCurrentLoyalty(stack);
        int max = this.getMaxLoyalty(stack);
        if (id == 5 && current > 0) {
            this.setLoyalty(stack, Math.max(current - 1, 0));
        }
        if (id == 4 && current < max) {
            this.setRiptide(stack, 0);
            this.setLoyalty(stack, Math.min(max, current + 1));
        }
        current = this.getCurrentRiptide(stack);
        max = this.getMaxRiptide(stack);
        if (id == 7 && current > 0) {
            this.setRiptide(stack, Math.max(current - 1, 0));
        }
        if (id == 6 && current < max) {
            this.setLoyalty(stack, 0);
            this.setRiptide(stack, Math.min(max, current + 1));
        }
        if (id == 8 && this.canChanneling(stack)) {
            this.setChanneling(stack, !this.getCurrentChanneling(stack));
        }
    }

    @Override
    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        new DissolutionChamberRecipe(ForgeRegistries.ITEMS.getKey((Object)this), new Ingredient.Value[]{new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41959_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42713_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41959_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42392_)), new Ingredient.ItemValue(new ItemStack((ItemLike)ModuleCore.RANGE_ADDONS[11].get())), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2000), 400, new ItemStack((ItemLike)this), FluidStack.EMPTY);
    }

    @Override
    public void addTooltipDetails(BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        this.addTooltip(tooltip, "enchantment.minecraft.loyalty", this.getCurrentLoyalty(stack));
        this.addTooltip(tooltip, "enchantment.minecraft.riptide", this.getCurrentRiptide(stack));
        this.addTooltip(tooltip, "enchantment.minecraft.channeling", this.getCurrentChanneling(stack) ? 1 : 0);
    }

    private void addTooltip(List<Component> tooltip, String type, int value) {
        if (value > 0) {
            String level = "0";
            switch (value) {
                case 1: {
                    level = "I";
                    break;
                }
                case 2: {
                    level = "II";
                    break;
                }
                case 3: {
                    level = "III";
                    break;
                }
                case 4: {
                    level = "IV";
                    break;
                }
                case 5: {
                    level = "V";
                }
            }
            tooltip.add((Component)Component.m_237115_((String)type).m_130946_(" " + level).m_130940_(ChatFormatting.GRAY));
        }
    }
}

