/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component.custom;

import com.buuz135.industrial.api.conveyor.gui.PositionedGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public abstract class TexturedStateButtonGuiComponent
extends PositionedGuiComponent {
    private final int id;
    private StateButtonInfo[] buttonInfos;

    public TexturedStateButtonGuiComponent(int id, int x, int y, int xSize, int ySize, StateButtonInfo ... buttonInfos) {
        super(x, y, xSize, ySize);
        this.id = id;
        this.buttonInfos = new StateButtonInfo[0];
        if (buttonInfos != null) {
            this.buttonInfos = buttonInfos;
        }
    }

    @Override
    public boolean handleClick(AbstractContainerScreen conveyor, int guiX, int guiY, double mouseX, double mouseY) {
        if (conveyor instanceof ICanSendNetworkMessage) {
            ((ICanSendNetworkMessage)conveyor).sendMessage(this.id, new CompoundTag());
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance((SoundEvent)SoundEvents.f_12490_.get(), SoundSource.PLAYERS, 1.0f, 0.5f, Minecraft.m_91087_().f_91073_.f_46441_, Minecraft.m_91087_().f_91074_.m_20183_()));
        return true;
    }

    @Override
    public void drawGuiBackgroundLayer(GuiGraphics guiGraphics, int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280218_(buttonInfo.getTexture(), guiX + this.getXPos(), guiY + this.getYPos(), buttonInfo.getTextureX(), buttonInfo.getTextureY(), this.getXSize(), this.getYSize());
        }
    }

    @Override
    public void drawGuiForegroundLayer(GuiGraphics guiGraphics, int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null && this.isInside(mouseX, mouseY)) {
            guiGraphics.m_280509_(this.getXPos() - guiX, this.getYPos() - guiY, this.getXPos() + this.getXSize() - guiX, this.getYPos() + this.getYSize() - guiY, -2130706433);
        }
    }

    @Override
    @Nullable
    public List<Component> getTooltip(int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            return Arrays.asList(buttonInfo.getTooltip());
        }
        return null;
    }

    public abstract int getState();

    private StateButtonInfo getStateInfo() {
        for (StateButtonInfo buttonInfo : this.buttonInfos) {
            if (buttonInfo.getState() != this.getState()) continue;
            return buttonInfo;
        }
        return null;
    }
}

