/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Function;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RenderHelpers {
    private static final Random rand = new Random();
    public static final int SLOT_SIZE = 16;
    public static final Function<ResourceLocation, TextureAtlasSprite> TEXTURE_GETTER = location -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(location);

    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void emitParticle(Particle particle) {
        Minecraft.m_91087_().f_91061_.m_107344_(particle);
    }

    public static void drawScaledString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, float scale, int color, boolean shadow, Font.DisplayMode displayMode) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        fontRenderer.m_271703_(string, 0.0f, 0.0f, color, shadow, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), displayMode, 0, 0xF000F0);
        guiGraphics.m_280168_().m_85849_();
    }

    @Deprecated
    public static void drawScaledString(PoseStack matrixStack, MultiBufferSource multiBufferSource, Font fontRenderer, String string, int x, int y, float scale, int color, boolean shadow, Font.DisplayMode displayMode) {
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)x, (float)y, 0.0f);
        matrixStack.m_85841_(scale, scale, 1.0f);
        fontRenderer.m_271703_(string, 0.0f, 0.0f, color, shadow, matrixStack.m_85850_().m_252922_(), multiBufferSource, displayMode, 0, 0xF000F0);
        matrixStack.m_85849_();
    }

    public static void drawScaledCenteredString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, int maxWidth, int color, boolean shadow, Font.DisplayMode displayMode) {
        RenderHelpers.drawScaledCenteredString(guiGraphics, fontRenderer, string, x, y, maxWidth, 1.0f, maxWidth, color, shadow, displayMode);
    }

    @Deprecated
    public static void drawScaledCenteredString(PoseStack matrixStack, MultiBufferSource multiBufferSource, Font fontRenderer, String string, int x, int y, int maxWidth, int color, boolean shadow, Font.DisplayMode displayMode) {
        RenderHelpers.drawScaledCenteredString(matrixStack, multiBufferSource, fontRenderer, string, x, y, maxWidth, 1.0f, maxWidth, color, shadow, displayMode);
    }

    public static void drawScaledCenteredString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, int width, float originalScale, int maxWidth, int color, boolean shadow, Font.DisplayMode displayMode) {
        float originalWidth = (float)fontRenderer.m_92895_(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        RenderHelpers.drawScaledCenteredString(guiGraphics, fontRenderer, string, x, y, width, scale, color, shadow, displayMode);
    }

    @Deprecated
    public static void drawScaledCenteredString(PoseStack matrixStack, MultiBufferSource multiBufferSource, Font fontRenderer, String string, int x, int y, int width, float originalScale, int maxWidth, int color, boolean shadow, Font.DisplayMode displayMode) {
        float originalWidth = (float)fontRenderer.m_92895_(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        RenderHelpers.drawScaledCenteredString(matrixStack, multiBufferSource, fontRenderer, string, x, y, width, scale, color, shadow, displayMode);
    }

    public static void drawScaledCenteredString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, int width, float scale, int color, boolean shadow, Font.DisplayMode displayMode) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        int titleLength = fontRenderer.m_92895_(string);
        Objects.requireNonNull(fontRenderer);
        int titleHeight = 9;
        fontRenderer.m_271703_(string, (float)Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), (float)Math.round((float)y / scale - (float)(titleHeight / 2)), color, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.m_280168_().m_85849_();
    }

    @Deprecated
    public static void drawScaledCenteredString(PoseStack matrixStack, MultiBufferSource multiBufferSource, Font fontRenderer, String string, int x, int y, int width, float scale, int color, boolean shadow, Font.DisplayMode displayMode) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, 1.0f);
        int titleLength = fontRenderer.m_92895_(string);
        Objects.requireNonNull(fontRenderer);
        int titleHeight = 9;
        fontRenderer.m_271703_(string, (float)Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), (float)Math.round((float)y / scale - (float)(titleHeight / 2)), color, false, matrixStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        matrixStack.m_85849_();
    }

    public static BakedModel getBakedModel(BlockState blockState) {
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher blockRendererDispatcher = mc.m_91289_();
        BlockModelShaper blockModelShapes = blockRendererDispatcher.m_110907_();
        return blockModelShapes.m_110893_(blockState);
    }

    public static BakedModel getDynamicBakedModel(Level world, BlockPos pos) {
        return RenderHelpers.getBakedModel(world.m_8055_(pos));
    }

    public static void addBlockHitEffects(ParticleEngine particleManager, ClientLevel world, BlockState blockState, BlockPos pos, Direction side) {
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            float f = 0.1f;
            AABB bb = blockState.m_60808_((BlockGetter)world, pos).m_83215_();
            double d0 = (double)i + rand.nextDouble() * (bb.f_82291_ - bb.f_82288_ - (double)(f * 2.0f)) + (double)f + bb.f_82288_;
            double d1 = (double)j + rand.nextDouble() * (bb.f_82292_ - bb.f_82289_ - (double)(f * 2.0f)) + (double)f + bb.f_82289_;
            double d2 = (double)k + rand.nextDouble() * (bb.f_82293_ - bb.f_82290_ - (double)(f * 2.0f)) + (double)f + bb.f_82290_;
            if (side == Direction.DOWN) {
                d1 = (double)j + bb.f_82289_ - (double)f;
            }
            if (side == Direction.UP) {
                d1 = (double)j + bb.f_82292_ + (double)f;
            }
            if (side == Direction.NORTH) {
                d2 = (double)k + bb.f_82290_ - (double)f;
            }
            if (side == Direction.SOUTH) {
                d2 = (double)k + bb.f_82293_ + (double)f;
            }
            if (side == Direction.WEST) {
                d0 = (double)i + bb.f_82288_ - (double)f;
            }
            if (side == Direction.EAST) {
                d0 = (double)i + bb.f_82291_ + (double)f;
            }
            Particle fx = new TerrainParticle.Provider().m_6966_(new BlockParticleOption(ParticleTypes.f_123794_, blockState), world, d0, d1, d2, 0.0, 0.0, 0.0);
            particleManager.m_107344_(fx);
        }
    }

    public static TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(block.m_49966_());
    }

    public static TextureAtlasSprite getFluidIcon(Fluid fluid, Direction side) {
        return RenderHelpers.getFluidIcon(new FluidStack(fluid, 1000), side);
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluid, Direction side) {
        IClientFluidTypeExtensions renderProperties;
        TextureAtlasSprite icon;
        if (side == null) {
            side = Direction.UP;
        }
        if ((icon = (TextureAtlasSprite)TEXTURE_GETTER.apply((Object)(renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid())).getFlowingTexture(fluid))) == null || side == Direction.UP || side == Direction.DOWN) {
            icon = (TextureAtlasSprite)TEXTURE_GETTER.apply((Object)renderProperties.getStillTexture(fluid));
        }
        return icon;
    }

    public static void renderFluidContext(FluidStack fluid, PoseStack matrixStack, IFluidContextRender render) {
        if (fluid != null && fluid.getAmount() > 0) {
            matrixStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            Minecraft.m_91087_().m_91097_().m_174784_(TextureAtlas.f_118259_);
            render.render();
            RenderSystem.disableBlend();
            matrixStack.m_85849_();
        }
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(FluidStack fluidStack) {
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        int color = renderProperties.getTintColor(fluidStack);
        return Helpers.intToRGB(color);
    }

    public static int getFluidBakedQuadColor(FluidStack fluidStack) {
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        Triple<Float, Float, Float> colorParts = Helpers.intToRGB(renderProperties.getTintColor(fluidStack));
        return Helpers.RGBAToInt((int)(((Float)colorParts.getRight()).floatValue() * 255.0f), (int)(((Float)colorParts.getMiddle()).floatValue() * 255.0f), (int)(((Float)colorParts.getLeft()).floatValue() * 255.0f), 255);
    }

    public static boolean isPointInRegion(int left, int top, int width, int height, double pointX, double pointY) {
        return pointX >= (double)left && pointX < (double)(left + width) && pointY >= (double)top && pointY < (double)(top + height);
    }

    public static boolean isPointInRegion(Rectangle region, Point point) {
        return RenderHelpers.isPointInRegion(region.x, region.y, region.width, region.height, point.x, point.y);
    }

    public static boolean isPointInButton(Button button, int pointX, int pointY) {
        return RenderHelpers.isPointInRegion(button.m_252754_(), button.m_252907_(), button.m_5711_(), button.m_93694_(), pointX, pointY);
    }

    public static void blitColored(GuiGraphics guiGraphics, int x, int y, int z, float u, float v, int width, int height, float r, float g, float b, float a) {
        RenderHelpers.blitColored(guiGraphics, x, y, z, width, height, u / 256.0f, (u + (float)width) / 256.0f, v / 256.0f, (v + (float)height) / 256.0f, r, g, b, a);
    }

    public static void blitColored(GuiGraphics guiGraphics, int x, int y, int z, int width, int height, float u0, float u1, float v0, float v1, float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, (float)x, (float)y + (float)height, (float)z).m_7421_(u0, v1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)x + (float)width, (float)y + (float)height, (float)z).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)x + (float)width, (float)y, (float)z).m_7421_(u1, v0).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)x, (float)y, (float)z).m_7421_(u0, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static interface IFluidContextRender {
        public void render();
    }
}

