/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;

public class Tank
extends FluidTank
implements IFluidHandlerCapacity,
IFluidHandlerMutable {
    public Tank(int capacity) {
        super(capacity);
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty() || this.getFluid().getAmount() <= 0;
    }

    public boolean isFull() {
        return !this.getFluid().isEmpty() && this.getFluid().getAmount() >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return !this.getFluid().isEmpty() ? this.getFluid().getFluid() : null;
    }

    protected boolean replaceInnerFluid() {
        return true;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        if (this.replaceInnerFluid()) {
            super.writeToNBT(nbt);
        }
        this.writeTankToNBT(nbt);
        return nbt;
    }

    public CompoundTag writeToNBT(CompoundTag nbt, String tag) {
        CompoundTag subTag = new CompoundTag();
        this.writeToNBT(subTag);
        nbt.m_128365_(tag, (Tag)subTag);
        return nbt;
    }

    public FluidTank readFromNBT(CompoundTag nbt) {
        if (this.replaceInnerFluid()) {
            if (nbt.m_128441_("Empty")) {
                this.setFluid(null);
            }
            super.readFromNBT(nbt);
        }
        this.readTankFromNBT(nbt);
        return this;
    }

    public FluidTank readFromNBT(CompoundTag data, String tag) {
        CompoundTag subTag = data.m_128469_(tag);
        return this.readFromNBT(subTag);
    }

    public void writeTankToNBT(CompoundTag nbt) {
        nbt.m_128405_("capacity", this.getCapacity());
    }

    public void readTankFromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("capacity")) {
            this.setCapacity(nbt.m_128451_("capacity"));
        }
    }

    @Override
    public void setFluidInTank(int tank, FluidStack fluidStack) {
        if (tank == 0) {
            this.setFluid(fluidStack);
        }
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        if (tank == 0) {
            this.setCapacity(capacity);
        }
    }

    @Override
    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.getCapacity();
        }
        return 0;
    }
}

