/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.aoe;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.mining.IsEffectiveToolHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface AreaOfEffectIterator {
    public static final GenericLoaderRegistry<Loadable> LOADER = new GenericLoaderRegistry("AOE Iterator", false);

    public static void register(ResourceLocation name, RecordLoadable<? extends Loadable> loader) {
        ToolModule.LOADER.register(name, loader);
        LOADER.register(name, loader);
    }

    public Iterable<BlockPos> getBlocks(IToolStackView var1, UseOnContext var2, BlockState var3, AOEMatchType var4);

    private static boolean isEffective(IToolStackView tool, Level world, BlockPos pos, float refHardness) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        float hardness = state.m_60800_((BlockGetter)world, pos);
        if (hardness == -1.0f) {
            return false;
        }
        if (refHardness == 0.0f ? hardness == 0.0f : hardness / refHardness <= 3.0f) {
            return IsEffectiveToolHook.isEffective(tool, state);
        }
        return false;
    }

    public static Predicate<BlockPos> defaultBlockPredicate(IToolStackView tool, UseOnContext context, AOEMatchType matchType) {
        Level world = context.m_43725_();
        if (matchType == AOEMatchType.DISPLAY) {
            return pos -> !world.m_46859_(pos);
        }
        BlockPos origin = context.m_8083_();
        float refHardness = world.m_8055_(origin).m_60800_((BlockGetter)world, origin);
        if (matchType == AOEMatchType.TRANSFORM) {
            return pos -> {
                Level level = context.m_43725_();
                if (AreaOfEffectIterator.isEffective(tool, level, pos, refHardness)) {
                    return true;
                }
                BlockState offsetState = level.m_8055_(pos);
                for (ModifierEntry entry : tool.getModifiers()) {
                    if (!entry.getHook(ModifierHooks.AOE_HIGHLIGHT).shouldHighlight(tool, entry, context, (BlockPos)pos, offsetState)) continue;
                    return true;
                }
                return false;
            };
        }
        return pos -> AreaOfEffectIterator.isEffective(tool, world, pos, refHardness);
    }

    public static enum AOEMatchType {
        BREAKING,
        TRANSFORM,
        DISPLAY;

    }

    public static interface Loadable
    extends AreaOfEffectIterator,
    ToolModule {
        public static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.AOE_ITERATOR);

        @Override
        default public List<ModuleHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }
    }
}

