/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.book.content.AbstractMaterialContent;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableBowItem;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableCrossbowItem;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class RangedMaterialContent
extends AbstractMaterialContent {
    public static final ResourceLocation ID = TConstruct.getResource("ranged_material");

    public RangedMaterialContent(MaterialVariantId materialVariant, boolean detailed) {
        super(materialVariant, detailed);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    @Nullable
    protected MaterialStatsId getStatType(int index) {
        return switch (index) {
            case 0 -> LimbMaterialStats.ID;
            case 1 -> GripMaterialStats.ID;
            case 2 -> StatlessMaterialStats.BOWSTRING.getIdentifier();
            default -> null;
        };
    }

    @Override
    protected String getTextKey(MaterialId material) {
        if (this.detailed) {
            String primaryKey = String.format("material.%s.%s.ranged", material.m_135827_(), material.m_135815_());
            if (Util.canTranslate(primaryKey)) {
                return primaryKey;
            }
            return String.format("material.%s.%s.encyclopedia", material.m_135827_(), material.m_135815_());
        }
        return String.format("material.%s.%s.flavor", material.m_135827_(), material.m_135815_());
    }

    @Override
    protected boolean supportsStatType(MaterialStatsId statsId) {
        return statsId.equals((Object)LimbMaterialStats.ID) || statsId.equals((Object)GripMaterialStats.ID) || statsId.equals((Object)StatlessMaterialStats.BOWSTRING.getIdentifier());
    }

    @Override
    protected void addCategory(List<ItemElement> displayTools, MaterialId material) {
        if (MaterialRegistry.getInstance().isInTag(material, TinkerTags.Materials.BALANCED)) {
            displayTools.add(RangedMaterialContent.makeCategoryIcon(((ModifiableItem)TinkerTools.swasher.get()).getRenderTool(), TConstruct.getResource("balanced")));
        } else if (MaterialRegistry.getInstance().isInTag(material, TinkerTags.Materials.LIGHT)) {
            displayTools.add(RangedMaterialContent.makeCategoryIcon(((ModifiableCrossbowItem)TinkerTools.crossbow.get()).getRenderTool(), TConstruct.getResource("light")));
        } else if (MaterialRegistry.getInstance().isInTag(material, TinkerTags.Materials.HEAVY)) {
            displayTools.add(RangedMaterialContent.makeCategoryIcon(((ModifiableBowItem)TinkerTools.longbow.get()).getRenderTool(), TConstruct.getResource("heavy")));
        }
    }
}

