/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.items;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.zeith.squarry.blocks.entity.TilePoweredQuarry;
import org.zeith.squarry.init.ItemsSQ;
import org.zeith.squarry.inventory.ContainerFilter;
import org.zeith.squarry.items.ItemUpgrade;

public class ItemFilterUpgrade
extends ItemUpgrade {
    public ItemFilterUpgrade() {
        super(new Item.Properties().m_41487_(1));
        this.quarryUseMultiplier = 1.0f;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            ContainerFilter.openFilter(player, hand);
        }
        return super.m_7203_(level, player, hand);
    }

    public static boolean matches(ItemStack filter, ItemStack input) {
        CompoundTag nbt = filter.m_41783_();
        if (nbt != null) {
            boolean invert = nbt.m_128471_("InvertList");
            boolean useod = nbt.m_128441_("OreDictionary") && nbt.m_128471_("OreDictionary");
            boolean usemeta = !nbt.m_128441_("Metadata") || nbt.m_128471_("Metadata");
            boolean ignorenbt = !nbt.m_128441_("IgnoreNBT") || nbt.m_128471_("IgnoreNBT");
            boolean applies = false;
            ListTag list = nbt.m_128437_("Filter", 10);
            for (int i = 0; i < list.size(); ++i) {
                boolean m3;
                ItemStack ft = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                if (ft.m_41619_()) continue;
                if (ft.m_41720_() == ItemsSQ.UPGRADE_FILTER && ItemFilterUpgrade.matches(ft, input)) {
                    applies = true;
                    break;
                }
                boolean m1 = useod && ItemFilterUpgrade.matchesByOD(input, ft);
                boolean m0 = ft.m_41720_() == input.m_41720_();
                boolean m2 = !usemeta || ft.m_41773_() == input.m_41773_();
                boolean bl = m3 = ignorenbt || Objects.equals(ft.m_41783_(), input.m_41783_());
                if (!m1 && (!m0 || !m2 || !m3)) continue;
                applies = true;
                break;
            }
            return invert != applies;
        }
        return true;
    }

    public static boolean matchesByOD(ItemStack a, ItemStack b) {
        if (a.m_41619_() && b.m_41619_()) {
            return true;
        }
        if (a.m_41619_() || b.m_41619_()) {
            return false;
        }
        Set tagsA = a.m_41720_().m_204114_().m_203616_().collect(Collectors.toSet());
        Set tagsB = b.m_41720_().m_204114_().m_203616_().collect(Collectors.toSet());
        return ItemFilterUpgrade.containsAny(tagsA, tagsB);
    }

    public static <T> boolean containsAny(Collection<T> coll1, Collection<T> coll2) {
        if (coll1.size() < coll2.size()) {
            for (T aColl1 : coll1) {
                if (!coll2.contains(aColl1)) continue;
                return true;
            }
        } else {
            for (T aColl1 : coll2) {
                if (!coll1.contains(aColl1)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFilterUpgrade(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() == ItemsSQ.UPGRADE_FILTER;
    }

    @Override
    public ItemStack handlePickup(ItemStack stack, TilePoweredQuarry quarry, int index) {
        if (!ItemFilterUpgrade.matches(quarry.getUpgradeStack(index), stack)) {
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Override
    public boolean isCompatible(TilePoweredQuarry quarry) {
        return !ItemFilterUpgrade.hasUpgrade(quarry, this);
    }
}

