/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.inventory;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.NetworkHooks;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.inv.IScreenContainer;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.squarry.client.screen.ScreenFilter;
import org.zeith.squarry.inventory.slots.SlotGhost;
import org.zeith.squarry.items.ItemFilterUpgrade;

@SimplyRegister
public class ContainerFilter
extends AbstractContainerMenu
implements IScreenContainer {
    @RegistryName(value="filter")
    public static final MenuType<ContainerFilter> FILTER = IForgeMenuType.create((windowId, playerInv, extraData) -> {
        FilterData tile = new FilterData(extraData.m_130267_());
        return new ContainerFilter(playerInv, windowId, tile);
    });
    public final Inventory inventory;
    public final FilterData data;

    public ContainerFilter(Inventory inventory, int windowId, FilterData data) {
        super(FILTER, windowId);
        int y;
        int x;
        this.inventory = inventory;
        this.data = data;
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 9; ++y) {
                this.m_38897_(new Slot((Container)inventory, y + x * 9 + 9, 8 + y * 18, 84 + x * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 142));
        }
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < 3; ++y) {
                this.m_38897_(new SlotGhost((Container)data.inventory, x + y * 4, 53 + x * 18, 17 + y * 18, data::getStack));
            }
        }
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            this.data.invert = !this.data.invert;
            this.data.getStack();
            return true;
        }
        if (id == 1) {
            this.data.useod = !this.data.useod;
            this.data.getStack();
            return true;
        }
        if (id == 2) {
            this.data.usemeta = !this.data.usemeta;
            this.data.getStack();
            return true;
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return this.data.isThisFilter(player.m_21120_(InteractionHand.MAIN_HAND));
    }

    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        return ItemStack.f_41583_;
    }

    private static MenuProvider forStack(final ItemStack filter) {
        return new MenuProvider(){

            public Component m_5446_() {
                return filter.m_41611_();
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
                return new ContainerFilter(player.m_150109_(), windowId, new FilterData(filter));
            }
        };
    }

    public static void openFilter(Player player, InteractionHand hand) {
        ItemStack hi = player.m_21120_(hand);
        if (!hi.m_41782_()) {
            hi.m_41751_(new CompoundTag());
        }
        if (!hi.m_41783_().m_128441_("FilterId")) {
            hi.m_41783_().m_128362_("FilterId", UUID.randomUUID());
        }
        if (!hi.m_41619_() && hi.m_41720_() instanceof ItemFilterUpgrade && player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)ContainerFilter.forStack(hi), buf -> buf.m_130055_(hi));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen openScreen(Inventory inv, Component label) {
        return new ScreenFilter(this, inv, label);
    }

    public static class FilterData {
        private final ItemStack stack;
        public SimpleInventory inventory = new SimpleInventory(12);
        public UUID id;
        public boolean invert;
        public boolean useod;
        public boolean usemeta;
        public boolean ignorenbt;

        public FilterData(ItemStack stack) {
            this.stack = stack;
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                this.id = nbt.m_128342_("FilterId");
                this.invert = nbt.m_128471_("InvertList");
                this.useod = nbt.m_128471_("OreDictionary");
                this.usemeta = nbt.m_128471_("Metadata");
                this.ignorenbt = nbt.m_128471_("IgnoreNBT");
                this.inventory.readFromNBT(nbt.m_128437_("Filter", 10));
            }
        }

        public ItemStack getStack() {
            CompoundTag nbt = this.stack.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            nbt.m_128362_("FilterId", this.id);
            nbt.m_128379_("InvertList", this.invert);
            nbt.m_128379_("OreDictionary", this.useod);
            nbt.m_128379_("Metadata", this.usemeta);
            nbt.m_128379_("IgnoreNBT", this.ignorenbt);
            nbt.m_128365_("Filter", (Tag)this.inventory.writeToNBT(new ListTag()));
            this.stack.m_41751_(nbt);
            return this.stack;
        }

        public boolean isThisFilter(ItemStack item) {
            return !item.m_41619_() && item.m_41720_() instanceof ItemFilterUpgrade && item.m_41782_() && Objects.equals(this.id, item.m_41783_().m_128342_("FilterId"));
        }
    }
}

