/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import org.joml.Matrix4f;
import org.zeith.hammerlib.client.screen.ScreenWTFMojang;
import org.zeith.hammerlib.client.utils.FXUtils;
import org.zeith.hammerlib.client.utils.RenderUtils;
import org.zeith.hammerlib.util.colors.ColorHelper;
import org.zeith.squarry.SQCommonProxy;
import org.zeith.squarry.SQConfig;
import org.zeith.squarry.api.energy.UniversalConverter;
import org.zeith.squarry.blocks.entity.TilePoweredQuarry;
import org.zeith.squarry.inventory.ContainerPoweredQuarry;
import org.zeith.squarry.mixins.GuiGraphicsAccessor;

public class ScreenPoweredQuarry
extends ScreenWTFMojang<ContainerPoweredQuarry> {
    public TilePoweredQuarry tile;
    private static final DecimalFormat df = new DecimalFormat("#0");

    public ScreenPoweredQuarry(ContainerPoweredQuarry container, Inventory inv, Component label) {
        super((AbstractContainerMenu)container, inv, label);
        this.tile = container.tile;
        this.setSize(176, 166);
    }

    protected void renderBackground(GuiGraphics gfx, float partialTime, int mouseX, int mouseY) {
        PoseStack pose = gfx.m_280168_();
        FXUtils.bindTexture((String)"squarry", (String)"textures/gui/powered_quarry.png");
        RenderUtils.drawTexturedModalRect((GuiGraphics)gfx, (float)this.f_97735_, (float)this.f_97736_, (float)0.0f, (float)0.0f, (float)this.f_97726_, (float)this.f_97727_);
        RenderUtils.drawTexturedModalRect((GuiGraphics)gfx, (float)((float)this.f_97735_ + 26.5f), (float)(this.f_97736_ + 34), (float)this.f_97726_, (float)14.0f, (float)13.0f, (float)13.0f);
        if (this.tile.totalBurnTicks.getInt() != 0) {
            float fire = 1.0f + (float)this.tile.burnTicks.getInt() / (float)this.tile.totalBurnTicks.getInt() * 13.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.drawTexturedModalRect((GuiGraphics)gfx, (float)(this.f_97735_ + 25), (float)((float)(this.f_97736_ + 47) - fire), (float)this.f_97726_, (float)(14.0f - fire), (float)14.0f, (float)fire);
        }
        float power = (float)(this.tile.storage.getStoredQF(null) / this.tile.storage.getQFCapacity(null) * 64.0);
        int finalCol = ColorHelper.interpolate((int)-8375296, (int)-103936, (float)(power / 64.0f));
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.fillGradient(gfx, this.f_97735_ + 7, (float)(this.f_97736_ + 72) - power, 11.0f, power, 0.0f, finalCol, -8375296);
    }

    protected boolean renderForeground(GuiGraphics gfx, int mx, int my) {
        PoseStack pose = gfx.m_280168_();
        if (mx - this.f_97735_ >= 6 && my - this.f_97736_ >= 7 && mx - this.f_97735_ <= 19 && my - this.f_97736_ <= 73) {
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.drawColoredModalRect((GuiGraphics)gfx, (float)7.0f, (float)8.0f, (float)11.0f, (float)64.0f, (int)-2130706433);
            ItemStack mouse = ((ContainerPoweredQuarry)this.f_97732_).m_142621_();
            if (mouse.m_41619_()) {
                gfx.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)(df.format(Math.floor(this.tile.storage.getStoredQF(null) / (UniversalConverter.FT_QF(ForgeHooks.getBurnTime((ItemStack)SQCommonProxy.COAL, null)) / SQConfig.getBlocksPerCoal()))) + " " + I18n.m_118938_((String)"info.squarry.blockstobreak", (Object[])new Object[0]))), 16, 48);
            }
        }
        return true;
    }

    public void fillGradient(GuiGraphics gfx, float x1, float y1, float width, float height, float z, int rgb1, int rgb2) {
        this.fillGradient(gfx, RenderType.m_285907_(), x1, y1, x1 + width, y1 + height, z, rgb1, rgb2);
    }

    public void fillGradient(GuiGraphics gfx, RenderType type, float x1, float y1, float x2, float y2, float z, int rgb1, int rgb2) {
        VertexConsumer vertexconsumer = gfx.m_280091_().m_6299_(type);
        this.fillGradient(gfx, vertexconsumer, x1, y1, x2, y2, z, rgb1, rgb2);
        ((GuiGraphicsAccessor)gfx).callFlushIfUnmanaged();
    }

    private void fillGradient(GuiGraphics gfx, VertexConsumer b, float x1, float y1, float x2, float y2, float z, int rgb1, int rgb2) {
        float f = (float)FastColor.ARGB32.m_13655_((int)rgb1) / 255.0f;
        float f1 = (float)FastColor.ARGB32.m_13665_((int)rgb1) / 255.0f;
        float f2 = (float)FastColor.ARGB32.m_13667_((int)rgb1) / 255.0f;
        float f3 = (float)FastColor.ARGB32.m_13669_((int)rgb1) / 255.0f;
        float f4 = (float)FastColor.ARGB32.m_13655_((int)rgb2) / 255.0f;
        float f5 = (float)FastColor.ARGB32.m_13665_((int)rgb2) / 255.0f;
        float f6 = (float)FastColor.ARGB32.m_13667_((int)rgb2) / 255.0f;
        float f7 = (float)FastColor.ARGB32.m_13669_((int)rgb2) / 255.0f;
        Matrix4f matrix4f = gfx.m_280168_().m_85850_().m_252922_();
        b.m_252986_(matrix4f, x1, y1, z).m_85950_(f1, f2, f3, f).m_5752_();
        b.m_252986_(matrix4f, x1, y2, z).m_85950_(f5, f6, f7, f4).m_5752_();
        b.m_252986_(matrix4f, x2, y2, z).m_85950_(f5, f6, f7, f4).m_5752_();
        b.m_252986_(matrix4f, x2, y1, z).m_85950_(f1, f2, f3, f).m_5752_();
    }
}

