/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.blocks.entity;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.squarry.SQConfig;
import org.zeith.squarry.blocks.BlockPoweredQuarry;
import org.zeith.squarry.blocks.entity.TileFuelQuarry;
import org.zeith.squarry.inventory.ContainerPoweredQuarry;
import org.zeith.squarry.items.ItemUpgrade;

@SimplyRegister
public class TilePoweredQuarry
extends TileFuelQuarry
implements IEnergyStorage {
    @RegistryName(value="powered_quarry")
    public static final BlockEntityType<TileFuelQuarry> POWERED_QUARRY = BlockAPI.createBlockEntityType(TilePoweredQuarry::new, (Block[])new Block[]{BlockPoweredQuarry.POWERED_QUARRY});
    @NBTSerializable
    public final SimpleInventory invUpgrades = new SimpleInventory(5);
    public CompoundTag additionalTags = new CompoundTag();
    final LazyOptional<IEnergyStorage> energyStorageTile = LazyOptional.of(() -> this);

    protected TilePoweredQuarry(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tickRate = SQConfig.getPoweredQuarryTickRate();
    }

    @Override
    protected double getQFCapacity() {
        return 256000.0;
    }

    @Override
    public double getUsageMult() {
        double val = super.getUsageMult();
        for (int i = 0; i < 5; ++i) {
            if (this.getUpgrade(i) == null) continue;
            val *= (double)this.getUpgrade((int)i).quarryUseMultiplierServer;
        }
        return val;
    }

    public ItemStack getUpgradeStack(int index) {
        return this.invUpgrades.getStackInSlot(index % 5);
    }

    public ItemUpgrade getUpgrade(int index) {
        Item item;
        ItemStack stack = this.getUpgradeStack(index);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ItemUpgrade) {
            ItemUpgrade u = (ItemUpgrade)item;
            return u;
        }
        return null;
    }

    public ItemUpgrade[] getUpgrades() {
        ItemUpgrade[] upgrades = new ItemUpgrade[5];
        for (int i = 0; i < 5; ++i) {
            upgrades[i] = this.getUpgrade(i);
        }
        return upgrades;
    }

    @Override
    public void update() {
        if (!SQConfig.isPoweredQuarry()) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.m_41619_()) {
            stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(pc -> {
                int canExtract = pc.extractEnergy(pc.getEnergyStored(), true);
                canExtract = Math.min(this.receiveEnergy(canExtract, true), canExtract);
                pc.extractEnergy(canExtract, false);
                this.receiveEnergy(canExtract, false);
            });
        }
        for (int i = 0; i < this.invUpgrades.m_6643_(); ++i) {
            ItemUpgrade up = this.getUpgrade(i);
            if (up != null && !up.canStay(this, i)) {
                ItemStack s = this.invUpgrades.getStackInSlot(i).m_41777_();
                this.invUpgrades.m_6836_(i, ItemStack.f_41583_);
                this.queueItems.add(s);
                continue;
            }
            if (up == null) continue;
            up.tick(this, i);
        }
        super.update();
        this.tickRate = SQConfig.getPoweredQuarryTickRate();
    }

    @Override
    public NonNullList<ItemStack> makeDrops(BlockPos pos, BlockState state) {
        NonNullList<ItemStack> drops = super.makeDrops(pos, state);
        for (int i = 0; i < this.invUpgrades.m_6643_(); ++i) {
            if (this.getUpgrade(i) == null) continue;
            this.getUpgrade(i).handleDrops(this, pos, drops);
        }
        return drops;
    }

    @Override
    public void addQueueItem(ItemStack e) {
        if (e.m_41619_()) {
            return;
        }
        for (int i = 0; i < this.invUpgrades.m_6643_(); ++i) {
            ItemUpgrade up = this.getUpgrade(i);
            if (up == null) continue;
            try {
                e = up.handlePickup(e, this, i);
                continue;
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        }
        if (!e.m_41619_()) {
            super.addQueueItem(e);
        }
    }

    @Override
    public AbstractContainerMenu openContainer(Player player, int windowId) {
        if (!SQConfig.isPoweredQuarry()) {
            return null;
        }
        return new ContainerPoweredQuarry(player, windowId, this);
    }

    @Override
    protected Block getQuarryBlock() {
        return BlockPoweredQuarry.POWERED_QUARRY;
    }

    @Override
    public void addToolEnchantments(Map<Enchantment, Integer> enchantmentMap) {
        for (int i = 0; i < this.invUpgrades.m_6643_(); ++i) {
            ItemUpgrade iu = this.getUpgrade(i);
            if (iu == null) continue;
            iu.addEnchantments(this, enchantmentMap);
        }
    }

    public void readNBT(CompoundTag nbt) {
        super.readNBT(nbt);
        this.additionalTags = nbt.m_128469_("AdditionalTags");
    }

    public CompoundTag writeNBT(CompoundTag nbt) {
        nbt = super.writeNBT(nbt);
        nbt.m_128365_("AdditionalTags", (Tag)this.additionalTags.m_6426_());
        return nbt;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!SQConfig.isPoweredQuarry()) {
            return 0;
        }
        float fec = SQConfig.getFeConversion();
        float hec = SQConfig.getHeConversion();
        if ((float)maxReceive >= fec) {
            return (int)(this.storage.consumeQF(null, (float)maxReceive / fec, simulate) * (double)fec);
        }
        return (int)(this.storage.consumeQF(null, (float)maxReceive / hec, simulate) * (double)hec);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 1000;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyStorageTile.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void dropEverything(Level world, BlockPos pos) {
        super.dropEverything(world, pos);
        Containers.m_19002_((Level)world, (BlockPos)pos, (Container)this.invUpgrades);
    }
}

