/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.blocks.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;
import org.zeith.api.wrench.IWrenchable;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyInt;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.tiles.tooltip.ITooltipConsumer;
import org.zeith.hammerlib.tiles.tooltip.ITooltipTile;
import org.zeith.hammerlib.util.java.DirectStorage;
import org.zeith.squarry.SQCommonProxy;
import org.zeith.squarry.SQConfig;
import org.zeith.squarry.SQConstants;
import org.zeith.squarry.SimpleQuarry;
import org.zeith.squarry.api.ItemInjector;
import org.zeith.squarry.api.ItemStackList;
import org.zeith.squarry.api.energy.QFStorage;
import org.zeith.squarry.api.particle.ParticleVortex;
import org.zeith.squarry.blocks.BlockBaseQuarry;
import org.zeith.squarry.blocks.BlockFuelQuarry;
import org.zeith.squarry.init.TagsSQ;
import org.zeith.squarry.inventory.ContainerFuelQuarry;

@SimplyRegister
public class TileFuelQuarry
extends TileSyncableTickable
implements IContainerTile,
IWrenchable,
ITooltipTile {
    @RegistryName(value="fuel_quarry")
    public static final BlockEntityType<TileFuelQuarry> FUEL_QUARRY = BlockAPI.createBlockEntityType(TileFuelQuarry::new, (Block[])new Block[]{BlockFuelQuarry.FUEL_QUARRY});
    public static final Map<ResourceKey<Level>, Map<ChunkPos, BlockPos>> QUARRY_MAP = new HashMap<ResourceKey<Level>, Map<ChunkPos, BlockPos>>();
    private static final Function<ResourceKey<Level>, Map<ChunkPos, BlockPos>> QUARRY_MAP_COMPUTE = world -> new HashMap();
    @NBTSerializable
    public final SimpleInventory inventory = new SimpleInventory(1);
    public int tickRate = SQConfig.getFuelQuarryTickRate();
    @NBTSerializable
    public int _burnTicks;
    @NBTSerializable
    public int _totalBurnTicks;
    @NBTSerializable(value="y")
    public int _y = Integer.MIN_VALUE;
    @NBTSerializable
    public final QFStorage storage = new QFStorage(this.getQFCapacity());
    @NBTSerializable
    public final ItemStackList queueItems = ItemStackList.createList();
    public AABB boundingBox;
    @NBTSerializable
    private ChunkPos chunkPos;
    public ParticleVortex vortex;
    public final PropertyInt burnTicks = new PropertyInt(DirectStorage.create($ -> {
        this._burnTicks = $;
    }, () -> this._burnTicks));
    public final PropertyInt totalBurnTicks = new PropertyInt(DirectStorage.create($ -> {
        this._totalBurnTicks = $;
    }, () -> this._totalBurnTicks));
    public final PropertyInt yLevel = new PropertyInt(DirectStorage.create($ -> {
        this._y = $;
    }, () -> this._y));

    protected double getQFCapacity() {
        return 8000.0;
    }

    protected TileFuelQuarry(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.dispatcher.registerProperty("burn_ticks", (IProperty)this.burnTicks);
        this.dispatcher.registerProperty("total_burn_ticks", (IProperty)this.totalBurnTicks);
        this.dispatcher.registerProperty("y", (IProperty)this.yLevel);
    }

    public void validateQuarry() {
        Map<ChunkPos, BlockPos> map = QUARRY_MAP.computeIfAbsent((ResourceKey<Level>)this.f_58857_.m_46472_(), QUARRY_MAP_COMPUTE);
        BlockPos cpos = map.get(this.chunkPos);
        if (cpos != null && cpos.m_121878_() != this.f_58858_.m_121878_() && this.f_58857_.m_7702_(cpos) instanceof TileFuelQuarry) {
            this.f_58857_.m_46961_(this.f_58858_, true);
            this.f_58857_.m_254849_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 3.0f, Level.ExplosionInteraction.NONE);
            return;
        }
        map.put(this.chunkPos, this.f_58858_);
    }

    protected Block getQuarryBlock() {
        return BlockFuelQuarry.FUEL_QUARRY;
    }

    public void update() {
        double qf;
        int bt;
        ItemStack stack;
        BlockState state0;
        LevelChunk c = this.f_58857_.m_46745_(this.f_58858_);
        ChunkPos pcp = this.chunkPos;
        this.chunkPos = c.m_7697_();
        int chunkX = this.chunkPos.f_45578_;
        int chunkZ = this.chunkPos.f_45579_;
        if (pcp != null && (pcp.f_45578_ != chunkX || pcp.f_45579_ != chunkZ)) {
            SimpleQuarry.LOG.info("Quarry moved from chunk {}, {} -> {}, {} (currently at {}). Reset Y level.", (Object)pcp.f_45578_, (Object)pcp.f_45579_, (Object)chunkX, (Object)chunkZ, (Object)this.f_58858_);
            this.yLevel.setInt(Integer.MIN_VALUE);
        }
        if (this.f_58857_.f_46443_) {
            int yMax = this.computeTopmostY();
            if (this.boundingBox == null || this.boundingBox.f_82289_ != (double)this._y || this.boundingBox.f_82292_ != (double)yMax + 0.5) {
                this.boundingBox = new AABB((double)(chunkX * 16), (double)this._y, (double)(chunkZ * 16), (double)(chunkX * 16 + 16), (double)yMax + 0.5, (double)(chunkZ * 16 + 16));
            }
            if (SQConfig.isParticleVortex()) {
                if (this.vortex == null) {
                    this.vortex = SimpleQuarry.PROXY.createQuarryVortex(this);
                }
                this.vortex.update();
            }
            return;
        }
        if (this.queueItems.size() >= 2) {
            this.tryEject();
            this.tickRate = SQConfig.getFuelQuarryTickRate();
            return;
        }
        if (this.storage.storedQF > 0.0 && this._y == Integer.MIN_VALUE) {
            this.yLevel.setInt(this.computeTopmostY());
            this.boundingBox = new AABB((double)(chunkX * 16), (double)this._y, (double)(chunkZ * 16), (double)(chunkX * 16 + 16), (double)(this._y + 1), (double)(chunkZ * 16 + 16));
            this.setEnabledState(true);
        }
        if (this.storage.storedQF > 0.0) {
            this.validateQuarry();
        }
        if ((state0 = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() != this.getQuarryBlock()) {
            this.tickRate = SQConfig.getFuelQuarryTickRate();
            return;
        }
        if (this._y > DimensionType.f_156653_ && this._y <= this.f_58857_.m_141937_()) {
            this.setEnabledState(false);
        }
        double QFPerBlock = SQConstants.FT.convertTo((double)ForgeHooks.getBurnTime((ItemStack)SQCommonProxy.COAL, null), SQConstants.QF) / SQConfig.getBlocksPerCoal();
        QFPerBlock *= this.getUsageMult();
        if (((Boolean)state0.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue() && !this.f_58857_.f_46443_ && this.atTickRate(20) && this._burnTicks < 1 && !(stack = this.inventory.getStackInSlot(0)).m_41619_() && (bt = ForgeHooks.getBurnTime((ItemStack)stack, null)) > 0 && this.storage.consumeQF(null, SQConstants.FT.convertTo(1.0, SQConstants.QF), true) == SQConstants.FT.convertTo(1.0, SQConstants.QF)) {
            this.burnTicks.setInt(this.burnTicks.getInt() + bt);
            this.totalBurnTicks.setInt(this.burnTicks.getInt());
            stack.m_41774_(1);
            this.sync();
        }
        if (this._burnTicks > 0) {
            this.burnTicks.setInt(this._burnTicks - 1);
            double ftqf = SQConstants.FT.convertTo(1.0, SQConstants.QF);
            double qf2 = this.storage.consumeQF(null, ftqf, true);
            if (qf2 == ftqf) {
                this.storage.consumeQF(null, qf2, false);
            }
            this.sync();
        }
        if (Double.isNaN(qf = this.storage.getStoredQF(null)) || Double.isInfinite(qf)) {
            this.storage.storedQF = 0.0;
        }
        if (this._y > this.f_58857_.m_141937_() && this.atTickRate(this.tickRate) && this.storage.getStoredQF(null) >= QFPerBlock) {
            if (this.f_58857_.m_8055_(new BlockPos(this.f_58858_.m_123341_(), this._y, this.f_58858_.m_123343_())).m_204336_(TagsSQ.Blocks.QUARRY_PIPE)) {
                this.yLevel.setInt(this._y - 1);
            } else {
                boolean hasBrokenBlock = false;
                for (BlockPos pos : BlockPos.m_121976_((int)(chunkX * 16), (int)this._y, (int)(chunkZ * 16), (int)(chunkX * 16 + 15), (int)this._y, (int)(chunkZ * 16 + 15))) {
                    BlockState state = this.f_58857_.m_8055_(pos);
                    if (this.f_58857_.m_46859_(pos) || !this.canBreak(state, pos)) continue;
                    this.captureItems((List<ItemStack>)this.makeDrops(pos, state));
                    hasBrokenBlock = true;
                    this.breakBlock(pos, state);
                    this.storage.produceQF(null, QFPerBlock, false);
                    this.sync();
                    break;
                }
                if (!hasBrokenBlock) {
                    this.yLevel.setInt(this._y - 1);
                }
            }
        }
        if (this.isMining(state0)) {
            this.captureEntityItems(this.f_58857_.m_45976_(ItemEntity.class, new AABB((double)(chunkX * 16), (double)this._y, (double)(chunkZ * 16), (double)(chunkX * 16 + 16), (double)this.f_58858_.m_123342_(), (double)(chunkZ * 16 + 16))));
        }
        this.tryEject();
        this.tickRate = SQConfig.getFuelQuarryTickRate();
    }

    public int computeTopmostY() {
        BlockPos pos = this.f_58858_.m_7949_().m_7495_();
        if (this.f_58857_ == null) {
            return pos.m_123342_();
        }
        while (this.f_58857_.m_8055_(pos).m_204336_(TagsSQ.Blocks.QUARRY_PIPE)) {
            pos = pos.m_7495_();
        }
        return pos.m_123342_();
    }

    public boolean isDone() {
        BlockState state0 = this.f_58857_.m_8055_(this.f_58858_);
        if (!this.f_58857_.f_46443_ && state0.m_60734_() == this.getQuarryBlock()) {
            return (Boolean)state0.m_61143_((Property)BlockStateProperties.f_61431_) == false;
        }
        return false;
    }

    public double getUsageMult() {
        return 1.0;
    }

    public void addToolEnchantments(Map<Enchantment, Integer> enchantmentMap) {
    }

    public NonNullList<ItemStack> makeDrops(BlockPos pos, BlockState state) {
        NonNullList drops = NonNullList.m_122779_();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            ItemStack tool = new ItemStack((ItemLike)Items.f_42390_);
            HashMap<Enchantment, Integer> enchMap = new HashMap<Enchantment, Integer>();
            this.addToolEnchantments(enchMap);
            EnchantmentHelper.m_44865_(enchMap, (ItemStack)tool);
            LootParams.Builder bl = new LootParams.Builder(sl).m_287286_(LootContextParams.f_81461_, (Object)state).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_287286_(LootContextParams.f_81463_, (Object)tool);
            BlockEntity be = this.f_58857_.m_7702_(pos);
            if (be != null) {
                bl = bl.m_287286_(LootContextParams.f_81462_, (Object)be);
            }
            drops.addAll((Collection)state.m_287290_(bl));
        }
        return drops;
    }

    public boolean isMining(BlockState state) {
        return state.m_60734_() == this.getQuarryBlock() && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61431_) != false && this._y > this.f_58857_.m_141937_() && this.storage.storedQF > 0.0;
    }

    public void breakBlock(BlockPos pos, BlockState state) {
        this.f_58857_.m_7471_(pos, false);
        FluidState fluidstate = this.f_58857_.m_6425_(pos);
        this.f_58857_.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        boolean flag = this.f_58857_.m_6933_(pos, fluidstate.m_76188_(), 3, 512);
        if (flag) {
            this.f_58857_.m_142346_(null, GameEvent.f_157794_, pos);
        }
    }

    public boolean canBreak(BlockState state, BlockPos pos) {
        if (state.m_60734_() instanceof LiquidBlock) {
            return false;
        }
        if (state.m_60800_((BlockGetter)this.f_58857_, pos) < 0.0f) {
            return false;
        }
        return !state.m_204336_(TagsSQ.Blocks.QUARRY_BLACKLIST);
    }

    public void dropStack(ItemStack stack) {
        RandomSource rand = this.f_58857_.m_213780_();
        if (!stack.m_41619_() && !this.f_58857_.f_46443_) {
            ItemEntity ei = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() + 0.5, stack.m_41777_());
            ei.m_20334_((rand.m_188500_() - rand.m_188500_()) * 0.045, 1.0 + rand.m_188500_() * 0.5, (rand.m_188500_() - rand.m_188500_()) * 0.045);
            this.f_58857_.m_7967_((Entity)ei);
        }
    }

    public void tryEject() {
        while (!this.queueItems.isEmpty()) {
            Direction face;
            BlockEntity tile;
            if (((ItemStack)this.queueItems.get(0)).m_41619_()) {
                this.queueItems.remove(0);
                continue;
            }
            ItemStack stack = (ItemStack)this.queueItems.remove(0);
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            for (int i = 0; i < n && !(stack = ItemInjector.inject(stack, tile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(face = directionArray[i])), face.m_122424_())).m_41619_(); ++i) {
            }
            if (stack.m_41619_()) continue;
            this.dropStack(stack);
        }
    }

    public void addQueueItem(ItemStack e) {
        this.queueItems.add(e);
    }

    public void captureItems(List<ItemStack> items) {
        while (!items.isEmpty()) {
            this.addQueueItem(items.remove(0));
        }
    }

    public void captureEntityItems(List<ItemEntity> items) {
        for (int j = 0; j < Math.min(items.size(), 1); ++j) {
            ItemEntity item = items.get(j);
            if (item.m_32055_().m_41613_() <= 0) continue;
            this.addQueueItem(item.m_32055_().m_41777_());
            item.m_32045_(ItemStack.f_41583_);
            item.m_6074_();
        }
    }

    public void setEnabledState(boolean enabled) {
        BlockState s = this.f_58857_.m_8055_(this.f_58858_);
        if (s.m_60734_() instanceof BlockBaseQuarry && !Objects.equals(s.m_61143_((Property)BlockStateProperties.f_61431_), enabled)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)s.m_61124_((Property)BlockStateProperties.f_61431_, (Comparable)Boolean.valueOf(enabled)));
            this.f_58857_.m_151523_((BlockEntity)this);
            this.sync();
        }
    }

    public boolean onWrenchUsed(UseOnContext context) {
        Direction facing;
        Direction origin;
        BlockState state;
        Direction d = context.m_43719_();
        if (context.m_43723_().m_6144_()) {
            d = d.m_122424_();
        }
        if ((state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() == BlockFuelQuarry.FUEL_QUARRY && (origin = (facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))) != (facing = d == Direction.UP ? facing.m_122427_() : (d == Direction.DOWN ? facing.m_122428_() : d))) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing));
        }
        return true;
    }

    public AbstractContainerMenu openContainer(Player player, int windowId) {
        return new ContainerFuelQuarry(player, windowId, this);
    }

    @Nullable
    public Component getDisplayName() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public void addTooltip(ITooltipConsumer consumer, Player player) {
        if (Integer.MIN_VALUE != this._y) {
            consumer.addLine((Component)Component.m_237113_((String)"Y: ").m_130946_(Integer.toString(this._y)));
        }
    }

    public void dropEverything(Level world, BlockPos pos) {
        Containers.m_19010_((Level)world, (BlockPos)pos, (NonNullList)this.queueItems);
        Containers.m_19010_((Level)world, (BlockPos)pos, (NonNullList)this.inventory.items);
    }
}

