/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.loading.FMLPaths;
import org.zeith.hammerlib.util.configured.ConfigFile;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.data.DecimalValueRange;
import org.zeith.hammerlib.util.configured.data.IntValueRange;
import org.zeith.hammerlib.util.configured.types.ConfigArray;
import org.zeith.hammerlib.util.configured.types.ConfigBoolean;
import org.zeith.hammerlib.util.configured.types.ConfigCategory;
import org.zeith.hammerlib.util.configured.types.ConfigDecimal;
import org.zeith.hammerlib.util.configured.types.ConfigInteger;
import org.zeith.hammerlib.util.configured.types.ConfigString;

public class SQConfig {
    public static final String COMMON_NAMESPACE = Tags.Items.RAW_MATERIALS.f_203868_().m_135827_();
    private static final String[] BASE_MATERIALS = new String[]{COMMON_NAMESPACE + ":raw_materials/", COMMON_NAMESPACE + ":nuggets/", COMMON_NAMESPACE + ":dusts/", COMMON_NAMESPACE + ":gems/"};
    private static double blocksPerCoal;
    private static int fuelQuarryTickRate;
    private static int poweredQuarryTickRate;
    private static boolean poweredQuarry;
    private static boolean easyPowerQuarryRecipe;
    private static float feConversion;
    private static float heConversion;
    private static boolean particleVortex;
    private static String[] allowedUnificationMaterials;
    private static String[] excludedUnificationEntries;
    private static boolean enableUnification;

    public static void reload() {
        File file = new File(FMLPaths.CONFIGDIR.get().toFile(), "squarry.cfg");
        try {
            ConfigFile cfg = ConfiguredLib.create((File)file, (boolean)true);
            cfg.withComment("Config file for Simple Quarry");
            ConfigCategory gameplay = (ConfigCategory)cfg.setupCategory("Gameplay").withComment("Core features of the mod");
            ConfigCategory fquarry = (ConfigCategory)gameplay.setupSubCategory("Fuel Quarry").withComment("All tweaks regarding Fuel Quarry");
            blocksPerCoal = ((ConfigDecimal)fquarry.getElement(ConfiguredLib.DECIMAL, "Blocks Per Coal")).withRange(DecimalValueRange.rangeClosed((double)0.0, (double)65536.0)).withDefault(96.0).withComment("How much blocks can 1 coal mine? This value is taken for all other fuel types as a standard.").getValue().doubleValue();
            fuelQuarryTickRate = ((ConfigInteger)fquarry.getElement(ConfiguredLib.INT, "Fuel Quarry Mine Tick Rate")).withRange(IntValueRange.rangeClosed((long)1L, (long)65536L)).withDefault(10).withComment("How frequently the Fuel Quarry will mine blocks?").getValue().intValue();
            ConfigCategory pquarry = (ConfigCategory)gameplay.setupSubCategory("Powered Quarry").withComment("All tweaks regarding Powered Quarry");
            poweredQuarry = ((ConfigBoolean)((ConfigBoolean)pquarry.getElement(ConfiguredLib.BOOLEAN, "Enabled")).withDefault(true).withComment("Should powered quarry be added into the game?")).getValue();
            poweredQuarryTickRate = ((ConfigInteger)pquarry.getElement(ConfiguredLib.INT, "Powered Quarry Mine Tick Rate")).withRange(IntValueRange.rangeClosed((long)1L, (long)65536L)).withDefault(5).withComment("How frequently the Powered Quarry will mine blocks?").getValue().intValue();
            easyPowerQuarryRecipe = ((ConfigBoolean)((ConfigBoolean)pquarry.getElement(ConfiguredLib.BOOLEAN, "Easy Powered Quarry Recipe")).withDefault(false).withComment("Enable easier power quarry recipe?")).getValue();
            feConversion = ((ConfigDecimal)pquarry.getElement(ConfiguredLib.DECIMAL, "Full Efficiency Conversion")).withRange(DecimalValueRange.rangeClosed((double)1.0, (double)65536.0)).withDefault(200.0).withComment("If the powered quarry gets this or higher amount of FE/transaction, it will be considered a full efficiency conversion to internal storage and divided by this value.").getValue().floatValue();
            heConversion = ((ConfigDecimal)pquarry.getElement(ConfiguredLib.DECIMAL, "Half Efficiency Conversion")).withRange(DecimalValueRange.rangeClosed((double)1.0, (double)65536.0)).withDefault(300.0).withComment("If the powered quarry doesn't get " + (int)feConversion + "+ FE/transaction, it will be considered a half efficiency conversion to internal storage and divided by this value.").getValue().floatValue();
            ConfigCategory unification = (ConfigCategory)gameplay.setupSubCategory("Unification Upgrade").withComment("All tweaks to unification upgrade.");
            enableUnification = ((ConfigBoolean)((ConfigBoolean)unification.getElement(ConfiguredLib.BOOLEAN, "Enabled")).withDefault(true).withComment("Should the unification upgrade perform unification? If set to 'false', the upgrade will do nothing.")).getValue();
            ConfigArray allowedPrefixes = ((ConfigArray)unification.getElement(ConfiguredLib.STRING.arrayOf(), "Allowed Prefixes")).withComment("This is a list of supported conversible tag groups.\nEvery entry ending with '/' would require item to have tags starting with the input entry.\nOtherwise it matches the tag precisely.");
            List elems = allowedPrefixes.getElements();
            if (elems.isEmpty()) {
                for (String mat : BASE_MATERIALS) {
                    elems.add(((ConfigString)allowedPrefixes.createElement()).withDefault(mat));
                }
            }
            HashSet<String> keys = new HashSet<String>();
            for (ConfigString string : new ArrayList(elems)) {
                if (keys.add(string.getValue())) continue;
                elems.remove(string);
            }
            allowedUnificationMaterials = (String[])keys.toArray(String[]::new);
            ConfigArray excludedItems = ((ConfigArray)unification.getElement(ConfiguredLib.STRING.arrayOf(), "Excluded Items")).withComment("This is a list items and/or tags (use '#' as first character to reference a tag) that are not going to be conversible.");
            excludedUnificationEntries = (String[])excludedItems.getElements().stream().map(ConfigString::getValue).distinct().toArray(String[]::new);
            ConfigCategory clientside = (ConfigCategory)cfg.setupCategory("Clientside").withComment("Client-side features of the mod");
            particleVortex = ((ConfigBoolean)((ConfigBoolean)clientside.getElement(ConfiguredLib.BOOLEAN, "Particle Vortex")).withDefault(true).withComment("Should quarry suck particles in?")).getValue();
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean enableUpgrades() {
        return poweredQuarry;
    }

    public static double getBlocksPerCoal() {
        return blocksPerCoal;
    }

    public static int getFuelQuarryTickRate() {
        return fuelQuarryTickRate;
    }

    public static int getPoweredQuarryTickRate() {
        return poweredQuarryTickRate;
    }

    public static boolean isPoweredQuarry() {
        return poweredQuarry;
    }

    public static boolean isEasyPowerQuarryRecipe() {
        return easyPowerQuarryRecipe;
    }

    public static float getFeConversion() {
        return feConversion;
    }

    public static float getHeConversion() {
        return heConversion;
    }

    public static boolean isParticleVortex() {
        return particleVortex;
    }

    public static String[] getAllowedUnificationMaterials() {
        return allowedUnificationMaterials;
    }

    public static String[] getExcludedUnificationEntries() {
        return excludedUnificationEntries;
    }

    public static boolean isEnableUnification() {
        return enableUnification;
    }

    static {
        allowedUnificationMaterials = (String[])BASE_MATERIALS.clone();
        excludedUnificationEntries = new String[0];
    }
}

