/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.registration;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.xstopho.resourcelibrary.platform.CoreServices;
import net.xstopho.resourcelibrary.registration.RegistryObject;

public interface RegistryProvider<T> {
    public static <T> RegistryProvider<T> get(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        return Factory.INSTANCE.create(resourceKey, modId);
    }

    public static <T> RegistryProvider<T> get(Registry<T> registry, String modId) {
        return Factory.INSTANCE.create(registry, modId);
    }

    public <I extends T> RegistryObject<I> register(String var1, Supplier<? extends I> var2);

    public Collection<RegistryObject<T>> getEntries();

    public String getModId();

    public static interface Factory {
        public static final Factory INSTANCE = CoreServices.load(Factory.class);

        public <T> RegistryProvider<T> create(ResourceKey<? extends Registry<T>> var1, String var2);

        default public <T> RegistryProvider<T> create(Registry<T> registry, String modId) {
            return this.create(registry.m_123023_(), modId);
        }
    }
}

